/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.rcp.internal.department;

import com.swtdesigner.ResourceManager;
import com.swtdesigner.SWTResourceManager;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;
import org.gastro.business.BusinessDay;
import org.gastro.business.Order;
import org.gastro.business.OrderDetail;
import org.gastro.business.OrderState;
import org.gastro.inventory.Department;
import org.gastro.inventory.Product;
import org.gastro.rcp.IModel;

public class OrdersView
extends ViewPart {
    public static final String ID = "org.gastro.rcp.orders.view";
    private static final AdapterFactory FACTORY = IModel.INSTANCE.getAdapterFactory();
    private TreeViewer treeViewer;
    private Adapter businessDayAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            try {
                OrdersView.this.treeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            OrdersView.this.treeViewer.refresh(true);
                            OrdersView.this.treeViewer.expandAll();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public void setFocus() {
    }

    public void dispose() {
        IModel.INSTANCE.getBusinessDay().eAdapters().remove((Object)this.businessDayAdapter);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        BusinessDay businessDay = IModel.INSTANCE.getBusinessDay();
        businessDay.eAdapters().add((Object)this.businessDayAdapter);
        this.treeViewer = new TreeViewer(parent, 0);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (object instanceof OrderDetail) {
                    OrderDetail orderDetail = (OrderDetail)object;
                    IModel.INSTANCE.modify((CDOObject)orderDetail, (IModel.ITransactionalOperation)new IModel.ITransactionalOperation<OrderDetail>(){

                        public Object execute(OrderDetail orderDetail) {
                            orderDetail.setState(orderDetail.getState() == OrderState.ORDERED ? OrderState.SERVED : OrderState.ORDERED);
                            return null;
                        }
                    });
                    OrdersView.this.treeViewer.refresh(true);
                }
            }
        });
        Tree tree = this.treeViewer.getTree();
        tree.setToolTipText("Klicken um Zustand zu wechseln");
        tree.setForeground(SWTResourceManager.getColor(10));
        tree.setFont(SWTResourceManager.getFont("Segoe UI", 16, 1));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnTitel = treeViewerColumn.getColumn();
        trclmnTitel.setToolTipText("Klicken um Zustand zu wechseln");
        trclmnTitel.setWidth(400);
        trclmnTitel.setText("Angebot");
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnQuantity = treeViewerColumn.getColumn();
        trclmnQuantity.setResizable(false);
        trclmnQuantity.setAlignment(131072);
        trclmnQuantity.setWidth(50);
        trclmnQuantity.setText("Menge");
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnPreis = treeViewerColumn.getColumn();
        trclmnPreis.setAlignment(131072);
        trclmnPreis.setResizable(false);
        trclmnPreis.setWidth(100);
        trclmnPreis.setText("Preis");
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnSumme = treeViewerColumn.getColumn();
        trclmnSumme.setAlignment(131072);
        trclmnSumme.setResizable(false);
        trclmnSumme.setWidth(100);
        trclmnSumme.setText("Summe");
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(FACTORY){

            public Object[] getElements(Object object) {
                return this.getChildren(object);
            }

            public Object[] getChildren(Object object) {
                Department department = (Department)IModel.INSTANCE.getStation();
                if (object instanceof BusinessDay) {
                    BusinessDay businessDay = (BusinessDay)object;
                    ArrayList<Order> result = new ArrayList<Order>();
                    block0: for (Order order : businessDay.getOrders()) {
                        for (OrderDetail orderDetail : order.getOrderDetails()) {
                            Product product;
                            if (orderDetail.getState() != OrderState.ORDERED || (product = orderDetail.getOffering().getProduct()) != null && product.getDepartment() != department) continue;
                            result.add(order);
                            continue block0;
                        }
                    }
                    return result.toArray();
                }
                if (object instanceof Order) {
                    Order order = (Order)object;
                    ArrayList<OrderDetail> result = new ArrayList<OrderDetail>();
                    for (OrderDetail orderDetail : order.getOrderDetails()) {
                        Product product = orderDetail.getOffering().getProduct();
                        if (product != null && product.getDepartment() != department) continue;
                        result.add(orderDetail);
                    }
                    return result.toArray();
                }
                return super.getChildren(object);
            }

            public boolean hasChildren(Object object) {
                return this.getChildren(object).length != 0;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider(FACTORY, (Viewer)this.treeViewer){

            public String getColumnText(Object object, int columnIndex) {
                if (object instanceof Order) {
                    Order order = (Order)object;
                    switch (columnIndex) {
                        case 0: {
                            return order.getTable().getStationID();
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            return "";
                        }
                    }
                }
                if (object instanceof OrderDetail) {
                    OrderDetail orderDetail = (OrderDetail)object;
                    switch (columnIndex) {
                        case 0: {
                            return orderDetail.getOffering().getName();
                        }
                        case 1: {
                            return orderDetail.getQuantity() + "x";
                        }
                        case 2: {
                            return this.formatPrice(orderDetail.getOffering().getPrice());
                        }
                        case 3: {
                            return this.formatPrice(orderDetail.getOffering().getPrice() * (float)orderDetail.getQuantity());
                        }
                    }
                }
                return super.getColumnText(object, columnIndex);
            }

            public Image getColumnImage(Object object, int columnIndex) {
                if (columnIndex == 0 && object instanceof OrderDetail) {
                    OrderDetail orderDetail = (OrderDetail)object;
                    if (orderDetail.getState() == OrderState.ORDERED) {
                        return ResourceManager.getPluginImage("org.gastro.rcp.department", "icons/ordered.gif");
                    }
                    return ResourceManager.getPluginImage("org.gastro.rcp.department", "icons/served.gif");
                }
                return null;
            }

            public Color getForeground(Object object, int columnIndex) {
                OrderDetail orderDetail;
                if (object instanceof OrderDetail && (orderDetail = (OrderDetail)object).getState() != OrderState.ORDERED) {
                    return OrdersView.this.treeViewer.getTree().getDisplay().getSystemColor(15);
                }
                return super.getForeground(object, columnIndex);
            }

            private String formatPrice(float price) {
                return NumberFormat.getCurrencyInstance().format(price);
            }
        });
        this.treeViewer.setInput((Object)businessDay);
        this.treeViewer.expandAll();
    }
}

