/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.tests.db.DBConfig;
import org.eclipse.emf.cdo.tests.db.bundle.OM;
import org.eclipse.emf.cdo.tests.db.verifier.DBStoreVerifier;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.hsqldb.HSQLDBAdapter;
import org.eclipse.net4j.db.hsqldb.HSQLDBDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqldbConfig
extends DBConfig {
    public static final String DB_ADAPTER_NAME = "Hsqldb";
    private static final long serialVersionUID = 1L;
    public static boolean USE_VERIFIER = false;
    private transient ArrayList<HSQLDBDataSource> dataSources;

    public HsqldbConfig() {
        super(DB_ADAPTER_NAME);
    }

    @Override
    protected String getDBAdapterName() {
        return DB_ADAPTER_NAME;
    }

    @Override
    protected IDBAdapter createDBAdapter() {
        return new HSQLDBAdapter();
    }

    @Override
    protected DataSource createDataSource(String repoName) {
        HSQLDBDataSource dataSource = new HSQLDBDataSource();
        dataSource.setDatabase("jdbc:hsqldb:mem:" + repoName);
        dataSource.setUser("sa");
        try {
            dataSource.setLogWriter(new PrintWriter(System.err));
        }
        catch (SQLException ex) {
            OM.LOG.warn(ex.getMessage());
        }
        if (this.dataSources == null) {
            this.dataSources = new ArrayList();
        }
        this.dataSources.add(dataSource);
        return dataSource;
    }

    public void tearDown() throws Exception {
        try {
            InternalRepository testRepository;
            if (USE_VERIFIER && (testRepository = this.getRepository("repo1")) != null) {
                this.getVerifier((IRepository)testRepository).verify();
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected void deactivateRepositories() {
        try {
            try {
                this.shutDownHsqldb();
            }
            catch (SQLException e) {
                throw new WrappedException((Exception)e);
            }
        }
        finally {
            super.deactivateRepositories();
        }
    }

    protected DBStoreVerifier getVerifier(IRepository repository) {
        return new DBStoreVerifier.Audit(repository);
    }

    private void shutDownHsqldb() throws SQLException {
        for (HSQLDBDataSource ds : this.dataSources) {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = ds.getConnection();
                statement = connection.createStatement();
                statement.execute("SHUTDOWN");
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
            DBUtil.close((Statement)statement);
            DBUtil.close((Connection)connection);
        }
        this.dataSources.clear();
    }

    protected void initRepositoryProperties(Map<String, String> props) {
        super.initRepositoryProperties(props);
        props.put("supportingAudits", "true");
    }
}

