/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.ddl.DBNamedElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;

public class CDODBSchema {
    public static final IDBSchema INSTANCE = DBUtil.createSchema((String)"CDO");
    public static final IDBTable PROPERTIES = INSTANCE.addTable("cdo_properties");
    public static final IDBField PROPERTIES_NAME = PROPERTIES.addField("name", DBType.VARCHAR, 255, true);
    public static final IDBField PROPERTIES_VALUE = PROPERTIES.addField("value", DBType.LONGVARCHAR);
    public static final IDBIndex INDEX_PROPERTIES_PK = PROPERTIES.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{PROPERTIES_NAME});
    public static final String SQL_DELETE_PROPERTIES = "DELETE FROM " + PROPERTIES + " WHERE " + PROPERTIES_NAME + "=?";
    public static final String SQL_INSERT_PROPERTIES = "INSERT INTO " + PROPERTIES + " (" + PROPERTIES_NAME + ", " + PROPERTIES_VALUE + ") VALUES (?, ?)";
    public static final String SQL_SELECT_PROPERTIES = "SELECT " + PROPERTIES_VALUE + " FROM " + PROPERTIES + " WHERE " + PROPERTIES_NAME + "=?";
    public static final String SQL_SELECT_ALL_PROPERTIES = "SELECT " + PROPERTIES_NAME + ", " + PROPERTIES_VALUE + " FROM " + PROPERTIES;
    public static final IDBTable PACKAGE_UNITS = INSTANCE.addTable("cdo_package_units");
    public static final IDBField PACKAGE_UNITS_ID = PACKAGE_UNITS.addField("id", DBType.VARCHAR, 255, true);
    public static final IDBField PACKAGE_UNITS_ORIGINAL_TYPE = PACKAGE_UNITS.addField("original_type", DBType.INTEGER);
    public static final IDBField PACKAGE_UNITS_TIME_STAMP = PACKAGE_UNITS.addField("time_stamp", DBType.BIGINT);
    public static final IDBField PACKAGE_UNITS_PACKAGE_DATA = PACKAGE_UNITS.addField("package_data", DBType.BLOB);
    public static final IDBIndex INDEX_PACKAGE_UNITS_PK = PACKAGE_UNITS.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{PACKAGE_UNITS_ID});
    public static final IDBTable PACKAGE_INFOS = INSTANCE.addTable("cdo_package_infos");
    public static final IDBField PACKAGE_INFOS_URI = PACKAGE_INFOS.addField("uri", DBType.VARCHAR, 255, true);
    public static final IDBField PACKAGE_INFOS_PARENT = PACKAGE_INFOS.addField("parent", DBType.VARCHAR, 255);
    public static final IDBField PACKAGE_INFOS_UNIT = PACKAGE_INFOS.addField("unit", DBType.VARCHAR, 255);
    public static final IDBIndex INDEX_PACKAGE_INFOS_PK = PACKAGE_INFOS.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{PACKAGE_INFOS_URI});
    public static final IDBIndex INDEX_PACKAGE_INFOS_PARENT = PACKAGE_INFOS.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{PACKAGE_INFOS_PARENT});
    public static final IDBIndex INDEX_PACKAGE_INFOS_UNIT = PACKAGE_INFOS.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{PACKAGE_INFOS_UNIT});
    public static final IDBTable BRANCHES = INSTANCE.addTable("cdo_branches");
    public static final IDBField BRANCHES_ID = BRANCHES.addField("id", DBType.INTEGER, true);
    public static final IDBField BRANCHES_NAME = BRANCHES.addField("name", DBType.VARCHAR);
    public static final IDBField BRANCHES_BASE_BRANCH_ID = BRANCHES.addField("base_id", DBType.INTEGER);
    public static final IDBField BRANCHES_BASE_TIMESTAMP = BRANCHES.addField("base_time", DBType.BIGINT);
    public static final IDBIndex INDEX_BRANCHES_ID = BRANCHES.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{BRANCHES_ID});
    public static final String SQL_CREATE_BRANCH = "INSERT INTO " + BRANCHES + " (" + BRANCHES_ID + ", " + BRANCHES_NAME + ", " + BRANCHES_BASE_BRANCH_ID + ", " + BRANCHES_BASE_TIMESTAMP + ") VALUES (?, ?, ?, ?)";
    public static final String SQL_LOAD_BRANCH = "SELECT " + BRANCHES_NAME + ", " + BRANCHES_BASE_BRANCH_ID + ", " + BRANCHES_BASE_TIMESTAMP + " FROM " + BRANCHES + " WHERE " + BRANCHES_ID + "=?";
    public static final String SQL_RENAME_BRANCH = "UPDATE " + BRANCHES + " SET " + BRANCHES_NAME + "=?" + " WHERE " + BRANCHES_ID + "=?";
    public static final String SQL_LOAD_SUB_BRANCHES = "SELECT " + BRANCHES_ID + ", " + BRANCHES_NAME + ", " + BRANCHES_BASE_TIMESTAMP + " FROM " + BRANCHES + " WHERE " + BRANCHES_BASE_BRANCH_ID + "=?";
    public static final String SQL_LOAD_BRANCHES = "SELECT " + BRANCHES_ID + ", " + BRANCHES_NAME + ", " + BRANCHES_BASE_BRANCH_ID + ", " + BRANCHES_BASE_TIMESTAMP + " FROM " + BRANCHES + " WHERE " + BRANCHES_ID + " BETWEEN ? AND ? ORDER BY " + BRANCHES_ID;
    public static final IDBTable TAGS = INSTANCE.addTable("cdo_tags");
    public static final IDBField TAGS_NAME = TAGS.addField("name", DBType.VARCHAR, true);
    public static final IDBField TAGS_BRANCH = TAGS.addField("branch", DBType.INTEGER);
    public static final IDBField TAGS__TIMESTAMP = TAGS.addField("timestamp", DBType.BIGINT);
    public static final IDBIndex INDEX_TAGS_NAME = TAGS.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{TAGS_NAME});
    public static final String SQL_CREATE_TAG = "INSERT INTO " + TAGS + " (" + TAGS_NAME + ", " + TAGS_BRANCH + ", " + TAGS__TIMESTAMP + ") VALUES (?, ?, ?)";
    public static final String SQL_RENAME_TAG = "UPDATE " + TAGS + " SET " + TAGS_NAME + "=?" + " WHERE " + TAGS_NAME + "=?";
    public static final String SQL_MOVE_TAG = "UPDATE " + TAGS + " SET " + TAGS_BRANCH + "=?, " + TAGS__TIMESTAMP + "=? WHERE " + TAGS_NAME + "=?";
    public static final String SQL_DELETE_TAG = "DELETE FROM " + TAGS + " WHERE " + TAGS_NAME + "=?";
    public static final String SQL_LOAD_TAGS = "SELECT " + TAGS_NAME + ", " + TAGS_BRANCH + ", " + TAGS__TIMESTAMP + " FROM " + TAGS;
    public static final String SQL_LOAD_TAG = "SELECT " + TAGS_BRANCH + ", " + TAGS__TIMESTAMP + " FROM " + TAGS + " WHERE " + TAGS_NAME + "=?";
    public static final IDBTable LOBS = INSTANCE.addTable("cdo_lobs");
    public static final IDBField LOBS_ID = LOBS.addField("id", DBType.VARCHAR, 64, true);
    public static final IDBField LOBS_SIZE = LOBS.addField("lsize", DBType.BIGINT);
    public static final IDBField LOBS_BDATA = LOBS.addField("bdata", DBType.BLOB);
    public static final IDBField LOBS_CDATA = LOBS.addField("cdata", DBType.CLOB);
    public static final IDBIndex INDEX_LOBS_ID = LOBS.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{LOBS_ID});
    public static final String SQL_QUERY_LOBS = "SELECT 1 FROM " + LOBS + " WHERE " + LOBS_ID + "=?";
    public static final String SQL_HANDLE_LOBS = "SELECT " + LOBS_ID + ", " + LOBS_SIZE + ", " + LOBS_BDATA + ", " + LOBS_CDATA + " FROM " + LOBS;
    public static final String SQL_LOAD_LOB = "SELECT " + LOBS_SIZE + ", " + LOBS_BDATA + ", " + LOBS_CDATA + " FROM " + LOBS + " WHERE " + LOBS_ID + "=?";
    public static final String SQL_WRITE_BLOB = "INSERT INTO " + LOBS + "(" + LOBS_ID + ", " + LOBS_SIZE + ", " + LOBS_BDATA + ") VALUES(?, ?, ?)";
    public static final String SQL_WRITE_CLOB = "INSERT INTO " + LOBS + "(" + LOBS_ID + ", " + LOBS_SIZE + ", " + LOBS_CDATA + ") VALUES(?, ?, ?)";
    public static final String CDO_OBJECTS = DBNamedElement.name((String)"cdo_objects");

    static {
        ((InternalDBSchema)INSTANCE).lock();
    }
}

