/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalTopicManager;

public class RemoteTopicIndication
extends CDOServerReadIndication {
    private String id;
    private boolean subscribe;

    public RemoteTopicIndication(CDOServerProtocol protocol) {
        super(protocol, (short)69);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.id = in.readString();
        this.subscribe = in.readBoolean();
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalSession localSession = this.getSession();
        InternalTopicManager topicManager = this.getSession().getManager().getTopicManager();
        if (this.subscribe) {
            InternalSession[] internalSessionArray = topicManager.addSubscription(this.id, localSession);
            int n = internalSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalSession session = internalSessionArray[n2];
                out.writeXInt(session.getSessionID());
                ++n2;
            }
            out.writeXInt(-1);
        } else {
            topicManager.removeSubscription(this.id, localSession);
            out.writeBoolean(true);
        }
    }
}

