/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.util.function.Consumer;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GlobalPartAdapter
implements IWindowListener,
IPageListener,
IPartListener2 {
    private static final ConcurrentArray<GlobalPartAdapter> adapters = new ConcurrentArray<GlobalPartAdapter>(){

        protected GlobalPartAdapter[] newArray(int length) {
            return new GlobalPartAdapter[length];
        }
    };

    static {
        final IPartListener2 partListener = new IPartListener2(){

            public void partOpened(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partOpened(partRef));
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partClosed(partRef));
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partActivated(partRef));
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partDeactivated(partRef));
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partVisible(partRef));
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partHidden(partRef));
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partBroughtToTop(partRef));
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partInputChanged(partRef));
            }
        };
        final IPageListener pageListener = new IPageListener(){

            public void pageOpened(IWorkbenchPage page) {
                GlobalPartAdapter.notifyAdapters(a -> a.pageOpened(page));
                page.addPartListener(partListener);
            }

            public void pageClosed(IWorkbenchPage page) {
                page.removePartListener(partListener);
                GlobalPartAdapter.notifyAdapters(a -> a.pageClosed(page));
            }

            public void pageActivated(IWorkbenchPage page) {
                GlobalPartAdapter.notifyAdapters(a -> a.pageActivated(page));
            }
        };
        IWindowListener windowListener = new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                GlobalPartAdapter.notifyAdapters(a -> a.windowOpened(window));
                window.addPageListener(pageListener);
            }

            public void windowClosed(IWorkbenchWindow window) {
                window.removePageListener(pageListener);
                GlobalPartAdapter.notifyAdapters(a -> a.windowClosed(window));
            }

            public void windowActivated(IWorkbenchWindow window) {
                GlobalPartAdapter.notifyAdapters(a -> a.windowActivated(window));
            }

            public void windowDeactivated(IWorkbenchWindow window) {
                GlobalPartAdapter.notifyAdapters(a -> a.windowDeactivated(window));
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            window.addPageListener(pageListener);
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                page.addPartListener(partListener);
                ++n4;
            }
            ++n2;
        }
        workbench.addWindowListener(windowListener);
    }

    public GlobalPartAdapter(boolean register) {
        if (register) {
            this.register();
        }
    }

    public GlobalPartAdapter() {
        this(true);
    }

    public void register(boolean notifyOpen) {
        if (notifyOpen) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                this.windowOpened(window);
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IViewReference partRef;
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    this.pageOpened(page);
                    IViewReference[] iViewReferenceArray = page.getViewReferences();
                    int n5 = iViewReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        partRef = iViewReferenceArray[n6];
                        this.partOpened((IWorkbenchPartReference)partRef);
                        ++n6;
                    }
                    iViewReferenceArray = page.getEditorReferences();
                    n5 = iViewReferenceArray.length;
                    n6 = 0;
                    while (n6 < n5) {
                        partRef = iViewReferenceArray[n6];
                        this.partOpened((IWorkbenchPartReference)partRef);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        adapters.add((Object)this);
    }

    public void register() {
        this.register(false);
    }

    public void dispose(boolean notifyClose) {
        adapters.remove((Object)this);
        if (notifyClose) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference partRef;
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        partRef = iEditorReferenceArray[n6];
                        this.partClosed((IWorkbenchPartReference)partRef);
                        ++n6;
                    }
                    iEditorReferenceArray = page.getViewReferences();
                    n5 = iEditorReferenceArray.length;
                    n6 = 0;
                    while (n6 < n5) {
                        partRef = iEditorReferenceArray[n6];
                        this.partClosed((IWorkbenchPartReference)partRef);
                        ++n6;
                    }
                    this.pageClosed(page);
                    ++n4;
                }
                this.windowClosed(window);
                ++n2;
            }
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private static void notifyAdapters(Consumer<GlobalPartAdapter> consumer) {
        GlobalPartAdapter[] array = (GlobalPartAdapter[])adapters.get();
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                GlobalPartAdapter adapter = array[i];
                try {
                    consumer.accept(adapter);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
                ++i;
            }
        }
    }
}

