/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.internal.mongodb.Classes;
import org.eclipse.emf.cdo.server.internal.mongodb.Commits;
import org.eclipse.emf.cdo.server.internal.mongodb.IDHandler;
import org.eclipse.emf.cdo.server.internal.mongodb.MongoDBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.mongodb.Props;
import org.eclipse.emf.cdo.server.internal.mongodb.bundle.OM;
import org.eclipse.emf.cdo.server.mongodb.IMongoDBStore;
import org.eclipse.emf.cdo.server.mongodb.IMongoDBStoreAccessor;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class MongoDBStore
extends Store
implements IMongoDBStore,
InternalStore.NoQueryXRefs,
InternalStore.NoLargeObjects,
InternalStore.NoHandleRevisions,
InternalStore.NoRawAccess {
    public static final String TYPE = "mongodb";
    @ReflectUtil.ExcludeFromDump
    private ValueHandler[] valueHandlers = new ValueHandler[256];
    private IDHandler idHandler = new IDHandler.LongValue(this);
    private MongoURI mongoURI;
    private String dbName;
    private DB db;
    private Props props;
    private Commits commits;
    private Classes classes;
    private boolean firstStart;
    private long creationTime;
    private boolean branching;
    public static Map<String, InternalRepository> REPOS = new HashMap<String, InternalRepository>();

    public MongoDBStore() {
        super(TYPE, null, MongoDBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.DELTA}), MongoDBStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.AUDITING, IStore.RevisionTemporality.NONE}), MongoDBStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.NONE, IStore.RevisionParallelism.BRANCHING}));
    }

    public ValueHandler getValueHandler(CDOType type) {
        return this.valueHandlers[type.getTypeID() - -128];
    }

    protected void initValueHandlers() {
        this.initValueHandler(CDOType.OBJECT, new ValueHandler(){

            @Override
            public Object toMongo(Object value) {
                if (value == null) {
                    return null;
                }
                return MongoDBStore.this.idHandler.toValue((CDOID)value);
            }

            @Override
            public Object fromMongo(Object value) {
                if (value == null) {
                    return null;
                }
                return MongoDBStore.this.idHandler.fromValue(value);
            }
        });
        this.initValueHandler(CDOType.CHAR, new ValueHandler(){

            @Override
            public Object toMongo(Object value) {
                if (value == null) {
                    return null;
                }
                return Character.toString(((Character)value).charValue());
            }

            @Override
            public Object fromMongo(Object value) {
                if (value instanceof String) {
                    return Character.valueOf(((String)value).charAt(0));
                }
                return value;
            }
        });
        this.initValueHandler(CDOType.BYTE, new ValueHandler(){

            @Override
            public Object fromMongo(Object value) {
                if (value instanceof Integer) {
                    return (byte)((Integer)value).intValue();
                }
                return value;
            }
        });
        this.initValueHandler(CDOType.SHORT, new ValueHandler(){

            @Override
            public Object fromMongo(Object value) {
                if (value instanceof Integer) {
                    return (short)((Integer)value).intValue();
                }
                return value;
            }
        });
        this.initValueHandler(CDOType.LONG, new ValueHandler(){

            @Override
            public Object fromMongo(Object value) {
                if (value instanceof Integer) {
                    return (long)((Integer)value).intValue();
                }
                return value;
            }
        });
        this.initValueHandler(CDOType.FLOAT, new ValueHandler(){

            @Override
            public Object fromMongo(Object value) {
                if (value instanceof Double) {
                    return Float.valueOf((float)((Double)value).doubleValue());
                }
                return value;
            }
        });
        this.initValueHandler(CDOType.BIG_DECIMAL, new ValueHandler(){

            @Override
            public Object toMongo(Object value) {
                if (value == null) {
                    return null;
                }
                return ((BigDecimal)value).toPlainString();
            }

            @Override
            public Object fromMongo(Object value) {
                if (value == null) {
                    return null;
                }
                return new BigDecimal((String)value);
            }
        });
        this.initValueHandler(CDOType.BIG_INTEGER, new ValueHandler(){

            @Override
            public Object toMongo(Object value) {
                if (value == null) {
                    return null;
                }
                return ((BigInteger)value).toString();
            }

            @Override
            public Object fromMongo(Object value) {
                if (value == null) {
                    return null;
                }
                return new BigInteger((String)value);
            }
        });
        this.initValueHandler(CDOType.ENUM_ORDINAL, new ValueHandler(){

            @Override
            public Object getMongoDefaultValue(EStructuralFeature feature) {
                EEnum eenum = (EEnum)feature.getEType();
                String defaultValueLiteral = feature.getDefaultValueLiteral();
                if (defaultValueLiteral != null) {
                    EEnumLiteral literal = eenum.getEEnumLiteralByLiteral(defaultValueLiteral);
                    return literal.getValue();
                }
                Enumerator enumerator = (Enumerator)eenum.getDefaultValue();
                return enumerator.getValue();
            }
        });
        this.initValueHandler(CDOType.CUSTOM, new ValueHandler(){

            @Override
            public Object getMongoDefaultValue(EStructuralFeature feature) {
                Object defaultValue = feature.getDefaultValue();
                EClassifier eType = feature.getEType();
                EFactory factory = eType.getEPackage().getEFactoryInstance();
                return factory.convertToString((EDataType)eType, defaultValue);
            }
        });
    }

    protected void initValueHandler(CDOType type, ValueHandler valueHandler) {
        this.valueHandlers[type.getTypeID() - -128] = valueHandler;
    }

    public IDHandler getIDHandler() {
        return this.idHandler;
    }

    public void setIDHandler(IDHandler idHandler) {
        this.checkInactive();
        this.idHandler = idHandler;
    }

    public MongoURI getMongoURI() {
        return this.mongoURI;
    }

    public void setMongoURI(MongoURI mongoURI) {
        this.checkInactive();
        this.mongoURI = mongoURI;
    }

    public String getDBName() {
        return this.dbName;
    }

    public void setDBName(String dbName) {
        this.checkInactive();
        this.dbName = dbName;
    }

    public DB getDB() {
        return this.db;
    }

    public Props getProps() {
        return this.props;
    }

    public Commits getCommits() {
        return this.commits;
    }

    public Classes getClasses() {
        return this.classes;
    }

    public Map<String, String> getPersistentProperties(Set<String> names) {
        return this.props.get(names);
    }

    public void setPersistentProperties(Map<String, String> properties) {
        this.props.set(properties);
    }

    public void removePersistentProperties(Set<String> names) {
        this.props.remove(names);
    }

    public boolean isFirstStart() {
        return this.firstStart;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("org.eclipse.emf.cdo.server.mongodb.repositoryCreated", Long.toString(creationTime));
        this.props.set(map);
    }

    public boolean isBranching() {
        return this.branching;
    }

    public CDOID createObjectID(String val) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public boolean isLocal(CDOID id) {
        throw new UnsupportedOperationException();
    }

    public IMongoDBStoreAccessor getReader(ISession session) {
        return (IMongoDBStoreAccessor)super.getReader(session);
    }

    public IMongoDBStoreAccessor getWriter(ITransaction transaction) {
        return (IMongoDBStoreAccessor)super.getWriter(transaction);
    }

    protected IStoreAccessor createReader(ISession session) {
        return new MongoDBStoreAccessor((Store)this, session);
    }

    protected IStoreAccessor createWriter(ITransaction transaction) {
        return new MongoDBStoreAccessor((Store)this, transaction);
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return null;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return null;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.mongoURI, "mongoURI");
        this.checkState(this.dbName, "dbName");
    }

    protected void doActivate() throws Exception {
        InternalRepository repository = this.getRepository();
        this.branching = repository.isSupportingBranches();
        if (this.branching) {
            throw new IllegalStateException("Branching is not supported");
        }
        REPOS.put(repository.getName(), repository);
        super.doActivate();
        Mongo mongo = new Mongo(this.mongoURI);
        this.db = mongo.getDB(this.dbName);
        Set collectionNames = this.db.getCollectionNames();
        this.firstStart = !collectionNames.contains("props");
        this.props = new Props(this);
        this.commits = new Commits(this);
        this.classes = new Classes(this);
        LifecycleUtil.activate((Object)this.idHandler);
        this.setObjectIDTypes(this.idHandler.getObjectIDTypes());
        Arrays.fill(this.valueHandlers, new ValueHandler());
        this.initValueHandlers();
        if (this.firstStart) {
            this.firstStart();
        } else {
            this.reStart();
        }
    }

    protected void doDeactivate() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("org.eclipse.emf.cdo.server.mongodb.gracefullyShutDown", Boolean.TRUE.toString());
        map.put("org.eclipse.emf.cdo.server.mongodb.repositoryStopped", Long.toString(this.getRepository().getTimeStamp()));
        map.put("org.eclipse.emf.cdo.server.mongodb.nextLocalCDOID", Store.idToString((CDOID)this.idHandler.getNextLocalObjectID()));
        map.put("org.eclipse.emf.cdo.server.mongodb.lastCDOID", Store.idToString((CDOID)this.idHandler.getLastObjectID()));
        map.put("org.eclipse.emf.cdo.server.mongodb.lastClassiferID", Integer.toString(this.classes.getLastClassifierID()));
        map.put("org.eclipse.emf.cdo.server.mongodb.lastBranchID", Integer.toString(this.getLastBranchID()));
        map.put("org.eclipse.emf.cdo.server.mongodb.lastLocalBranchID", Integer.toString(this.getLastLocalBranchID()));
        map.put("org.eclipse.emf.cdo.server.mongodb.lastCommitTime", Long.toString(this.getLastCommitTime()));
        map.put("org.eclipse.emf.cdo.server.mongodb.lastNonLocalCommitTime", Long.toString(this.getLastNonLocalCommitTime()));
        this.setPersistentProperties(map);
        LifecycleUtil.deactivate((Object)this.idHandler);
        REPOS.remove(this.getRepository().getName());
        if (this.db != null) {
            this.db.getMongo().close();
            this.db = null;
        }
        super.doDeactivate();
    }

    protected void firstStart() {
        this.setCreationTime(this.getRepository().getTimeStamp());
        OM.LOG.info("First start: " + CDOCommonUtil.formatTimeStamp((long)this.creationTime));
    }

    protected void reStart() {
        HashSet<String> names = new HashSet<String>();
        names.add("org.eclipse.emf.cdo.server.mongodb.repositoryCreated");
        names.add("org.eclipse.emf.cdo.server.mongodb.gracefullyShutDown");
        Map<String, String> map = this.getPersistentProperties(names);
        this.creationTime = Long.valueOf(map.get("org.eclipse.emf.cdo.server.mongodb.repositoryCreated"));
        if (map.containsKey("org.eclipse.emf.cdo.server.mongodb.gracefullyShutDown")) {
            names.clear();
            names.add("org.eclipse.emf.cdo.server.mongodb.nextLocalCDOID");
            names.add("org.eclipse.emf.cdo.server.mongodb.lastCDOID");
            names.add("org.eclipse.emf.cdo.server.mongodb.lastClassiferID");
            names.add("org.eclipse.emf.cdo.server.mongodb.lastBranchID");
            names.add("org.eclipse.emf.cdo.server.mongodb.lastLocalBranchID");
            names.add("org.eclipse.emf.cdo.server.mongodb.lastCommitTime");
            names.add("org.eclipse.emf.cdo.server.mongodb.lastNonLocalCommitTime");
            map = this.getPersistentProperties(names);
            this.idHandler.setNextLocalObjectID(MongoDBStore.stringToID((String)map.get("org.eclipse.emf.cdo.server.mongodb.nextLocalCDOID")));
            this.idHandler.setLastObjectID(MongoDBStore.stringToID((String)map.get("org.eclipse.emf.cdo.server.mongodb.lastCDOID")));
            this.classes.setLastClassifierID(Integer.valueOf(map.get("org.eclipse.emf.cdo.server.mongodb.lastClassiferID")));
            this.setLastBranchID(Integer.valueOf(map.get("org.eclipse.emf.cdo.server.mongodb.lastBranchID")));
            this.setLastLocalBranchID(Integer.valueOf(map.get("org.eclipse.emf.cdo.server.mongodb.lastLocalBranchID")));
            this.setLastCommitTime(Long.valueOf(map.get("org.eclipse.emf.cdo.server.mongodb.lastCommitTime")));
            this.setLastNonLocalCommitTime(Long.valueOf(map.get("org.eclipse.emf.cdo.server.mongodb.lastNonLocalCommitTime")));
        } else {
            this.repairAfterCrash();
        }
        this.removePersistentProperties(Collections.singleton("org.eclipse.emf.cdo.server.mongodb.gracefullyShutDown"));
    }

    protected void repairAfterCrash() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static class ValueHandler {
        public Object getMongoDefaultValue(EStructuralFeature feature) {
            Object defaultValue = feature.getDefaultValue();
            return this.toMongo(defaultValue);
        }

        public Object toMongo(Object value) {
            return value;
        }

        public Object fromMongo(Object value) {
            return value;
        }
    }
}

