/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.security;

import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalRepository;

public abstract class SecurityManagerCommand
extends CDOCommand.WithRepository {
    public SecurityManagerCommand(String name, String description, CDOCommand.CommandParameter ... parameters) {
        super(name, description, parameters);
    }

    public SecurityManagerCommand(String name, String description) {
        super(name, description);
    }

    public void execute(InternalRepository repository, String[] args) throws Exception {
        ISecurityManager securityManager = SecurityManagerUtil.getSecurityManager((IRepository)repository);
        if (securityManager == null) {
            throw new CDOCommand.CommandException("Security manager not found for " + repository);
        }
        this.execute(securityManager, args);
    }

    protected abstract void execute(ISecurityManager var1, String[] var2);

    public static final class AddUser
    extends SecurityManagerCommand {
        public AddUser() {
            super("adduser", "adds a user to the security realm of a repository", AddUser.parameter((String)"username"), AddUser.optional((String)"password"));
        }

        @Override
        protected void execute(ISecurityManager securityManager, String[] args) {
            String username = args[0];
            String password = args[1];
            if (password != null) {
                securityManager.addUser(username, password);
            } else {
                securityManager.addUser(username);
            }
            this.println("User " + username + " added");
        }
    }

    public static final class SetPassword
    extends SecurityManagerCommand {
        public SetPassword() {
            super("setpassword", "sets or unsets the password of a repository user", SetPassword.parameter((String)"username"), SetPassword.optional((String)"password"));
        }

        @Override
        protected void execute(ISecurityManager securityManager, String[] args) {
            String username = args[0];
            String password = args[1];
            securityManager.setPassword(username, password);
            this.println("Password of user " + username + (password != null ? " set" : " unset"));
        }
    }
}

