/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;

@Immutable
public final class MongoNamespace {
    public static final String COMMAND_COLLECTION_NAME = "$cmd";
    private final String databaseName;
    private final String collectionName;
    private final String fullName;

    public MongoNamespace(String fullName) {
        Assertions.notNull("fullName", fullName);
        Assertions.isTrueArgument("fullName is of form <db>.<collection>", MongoNamespace.isFullNameValid(fullName));
        this.databaseName = MongoNamespace.getDatatabaseNameFromFullName(fullName);
        this.collectionName = MongoNamespace.getCollectionNameFullName(fullName);
        this.fullName = fullName;
    }

    public MongoNamespace(String databaseName, String collectionName) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.fullName = databaseName + "." + collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoNamespace that = (MongoNamespace)o;
        if (!this.collectionName.equals(that.collectionName)) {
            return false;
        }
        return this.databaseName.equals(that.databaseName);
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        int result = this.databaseName.hashCode();
        result = 31 * result + this.collectionName.hashCode();
        return result;
    }

    private static boolean isFullNameValid(String fullName) {
        int firstDotIndex = fullName.indexOf(".");
        if (firstDotIndex == -1) {
            return false;
        }
        if (firstDotIndex == 0) {
            return false;
        }
        if (fullName.charAt(fullName.length() - 1) == '.') {
            return false;
        }
        return fullName.charAt(firstDotIndex + 1) != '.';
    }

    private static String getCollectionNameFullName(String namespace) {
        return namespace.substring(namespace.indexOf(46) + 1);
    }

    private static String getDatatabaseNameFromFullName(String namespace) {
        return namespace.substring(0, namespace.indexOf(46));
    }
}

