/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.ITransportConfigAware;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.channel.ChannelInputStream;
import org.eclipse.net4j.channel.ChannelOutputStream;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.data.HugeData;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.spi.net4j.ClientProtocolFactory;
import org.eclipse.spi.net4j.InternalChannelMultiplexer;
import org.eclipse.spi.net4j.Protocol;
import org.eclipse.spi.net4j.ServerProtocolFactory;

public class TransportTest
extends AbstractConfigTest {
    protected IBuffer provideBuffer() {
        return this.provideBuffer(null);
    }

    protected IBuffer provideBuffer(IConnector connector) {
        return ((InternalChannelMultiplexer)connector).provideBuffer();
    }

    protected IBufferProvider provideBufferProvider(IConnector connector) {
        return ((ITransportConfigAware)connector).getConfig().getBufferProvider();
    }

    public void testConnect() throws Exception {
        this.startTransport();
    }

    public void testSendBuffer() throws Exception {
        this.startTransport();
        IConnector connector = this.getConnector();
        IChannel channel = connector.openChannel();
        int i = 0;
        while (i < 3) {
            IBuffer buffer = this.provideBuffer(connector);
            ByteBuffer byteBuffer = buffer.startPutting(channel.getID());
            byteBuffer.putInt(1970);
            channel.sendBuffer(buffer);
            ++i;
        }
    }

    public void testSendEmptyBuffer() throws Exception {
        this.startTransport();
        IConnector connector = this.getConnector();
        IChannel channel = connector.openChannel();
        int i = 0;
        while (i < 3) {
            IBuffer buffer = this.provideBuffer(connector);
            buffer.startPutting(channel.getID());
            channel.sendBuffer(buffer);
            ++i;
        }
    }

    public void testSendEmptyBufferWithoutStartPutting() throws Exception {
        this.startTransport();
        IConnector connector = this.getConnector();
        IChannel channel = connector.openChannel();
        IBuffer buffer = this.provideBuffer(connector);
        try {
            channel.sendBuffer(buffer);
            TransportTest.fail((String)"ChannelException expected because buffer is not in state PUTTING");
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    public void testHandleBuffer() throws Exception {
        int COUNT = 3;
        CountDownLatch counter = new CountDownLatch(3);
        this.acceptorContainer.registerFactory((IFactory)new TestProtocol.ServerFactory(counter));
        this.connectorContainer.registerFactory((IFactory)new TestProtocol.ClientFactory());
        this.startTransport();
        IConnector connector = this.getConnector();
        IChannel channel = connector.openChannel("test.protocol", null);
        int i = 0;
        while (i < 3) {
            IBuffer buffer = this.provideBuffer(connector);
            ByteBuffer byteBuffer = buffer.startPutting(channel.getID());
            byteBuffer.putInt(1970);
            channel.sendBuffer(buffer);
            TransportTest.sleep(50L);
            ++i;
        }
        TransportTest.assertEquals((boolean)true, (boolean)counter.await(2L, TimeUnit.SECONDS));
    }

    public void testHandleEmptyBuffer() throws Exception {
        int COUNT = 3;
        CountDownLatch counter = new CountDownLatch(3);
        this.acceptorContainer.registerFactory((IFactory)new TestProtocol.ServerFactory(counter));
        this.connectorContainer.registerFactory((IFactory)new TestProtocol.ClientFactory());
        this.startTransport();
        IConnector connector = this.getConnector();
        IChannel channel = connector.openChannel("test.protocol", null);
        int i = 0;
        while (i < 3) {
            IBuffer buffer = this.provideBuffer(connector);
            buffer.startPutting(channel.getID());
            channel.sendBuffer(buffer);
            ++i;
        }
        TransportTest.sleep(100L);
        TransportTest.assertEquals((long)3L, (long)counter.getCount());
    }

    public void testHandleEmptyBufferWithEOS() throws Exception {
        int COUNT = 3;
        CountDownLatch counter = new CountDownLatch(3);
        this.acceptorContainer.registerFactory((IFactory)new TestProtocol.ServerFactory(counter));
        this.connectorContainer.registerFactory((IFactory)new TestProtocol.ClientFactory());
        this.startTransport();
        IConnector connector = this.getConnector();
        IChannel channel = connector.openChannel("test.protocol", null);
        int i = 0;
        while (i < 3) {
            IBuffer buffer = this.provideBuffer(connector);
            buffer.startPutting(channel.getID());
            buffer.setEOS(true);
            channel.sendBuffer(buffer);
            ++i;
        }
        TransportTest.sleep(100L);
        TransportTest.assertEquals((long)0L, (long)counter.getCount());
    }

    public void testStreaming() throws Exception {
        boolean COUNT = true;
        final CountDownLatch counter = new CountDownLatch(1);
        final ChannelInputStream[] inputStream = new ChannelInputStream[1];
        this.getAcceptor().addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof IContainerEvent) {
                    IContainerEvent e = (IContainerEvent)event;
                    ((IConnector)e.getDeltaElement()).addListener(new IListener(){

                        public void notifyEvent(IEvent event) {
                            IContainerEvent e;
                            if (event instanceof IContainerEvent && (e = (IContainerEvent)event).getDeltaKind() == IContainerDelta.Kind.ADDED) {
                                inputStream[0] = new ChannelInputStream((IChannel)e.getDeltaElement(), 2000L);
                                counter.countDown();
                            }
                        }
                    });
                }
            }
        });
        IChannel channel = this.getConnector().openChannel();
        TransportTest.assertEquals((boolean)true, (boolean)counter.await(2L, TimeUnit.SECONDS));
        TransportTest.assertNotNull((Object)inputStream[0]);
        ChannelOutputStream outputStream = new ChannelOutputStream(channel);
        outputStream.write(HugeData.getBytes());
        outputStream.flushWithEOS();
        outputStream.close();
        try {
            String line;
            InputStreamReader isr = new InputStreamReader((InputStream)inputStream[0]);
            BufferedReader reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            isr.close();
        }
        catch (RuntimeException ex) {
            IOUtil.print((Throwable)ex);
        }
    }

    public void testTextStreaming() throws Exception {
        boolean COUNT = true;
        final CountDownLatch counter = new CountDownLatch(1);
        final ChannelInputStream[] inputStream = new ChannelInputStream[1];
        this.getAcceptor().addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof IContainerEvent) {
                    IContainerEvent e = (IContainerEvent)event;
                    ((IConnector)e.getDeltaElement()).addListener(new IListener(){

                        public void notifyEvent(IEvent event) {
                            IContainerEvent e;
                            if (event instanceof IContainerEvent && (e = (IContainerEvent)event).getDeltaKind() == IContainerDelta.Kind.ADDED) {
                                inputStream[0] = new ChannelInputStream((IChannel)e.getDeltaElement(), 2000L);
                                counter.countDown();
                            }
                        }
                    });
                }
            }
        });
        IChannel channel = this.getConnector().openChannel();
        TransportTest.assertEquals((boolean)true, (boolean)counter.await(2L, TimeUnit.SECONDS));
        TransportTest.assertNotNull((Object)inputStream[0]);
        ChannelOutputStream outputStream = new ChannelOutputStream(channel);
        PrintStream printer = new PrintStream((OutputStream)outputStream);
        StringTokenizer tokenizer = HugeData.getTokenizer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            printer.println(token);
        }
        outputStream.flushWithEOS();
        outputStream.close();
        try {
            String line;
            InputStreamReader isr = new InputStreamReader((InputStream)inputStream[0]);
            BufferedReader reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                TransportTest.msg(line);
            }
            isr.close();
        }
        catch (RuntimeException ex) {
            IOUtil.print((Throwable)ex);
        }
    }

    public void testTextStreamingDecoupled() throws Exception {
        boolean COUNT = true;
        final CountDownLatch counter = new CountDownLatch(1);
        final ChannelInputStream[] inputStream = new ChannelInputStream[1];
        this.getAcceptor().addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof IContainerEvent) {
                    IContainerEvent e = (IContainerEvent)event;
                    ((IConnector)e.getDeltaElement()).addListener(new IListener(){

                        public void notifyEvent(IEvent event) {
                            IContainerEvent e;
                            if (event instanceof IContainerEvent && (e = (IContainerEvent)event).getDeltaKind() == IContainerDelta.Kind.ADDED) {
                                inputStream[0] = new ChannelInputStream((IChannel)e.getDeltaElement(), 2000L);
                                counter.countDown();
                            }
                        }
                    });
                }
            }
        });
        final IConnector iConnector = this.getConnector();
        final IChannel channel = iConnector.openChannel();
        TransportTest.assertEquals((boolean)true, (boolean)counter.await(2L, TimeUnit.SECONDS));
        TransportTest.assertNotNull((Object)inputStream[0]);
        new Thread(){

            @Override
            public void run() {
                try {
                    IBufferProvider bufferProvider = TransportTest.this.provideBufferProvider(iConnector);
                    ChannelOutputStream outputStream = new ChannelOutputStream(channel, bufferProvider);
                    PrintStream printer = new PrintStream((OutputStream)outputStream);
                    StringTokenizer tokenizer = HugeData.getTokenizer();
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        printer.println(token);
                    }
                    outputStream.flushWithEOS();
                    outputStream.close();
                }
                catch (IOException ex) {
                    IOUtil.print((Throwable)ex);
                    TransportTest.fail((String)ex.getLocalizedMessage());
                }
            }
        }.start();
        try {
            String line;
            InputStreamReader isr = new InputStreamReader((InputStream)inputStream[0]);
            BufferedReader reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                TransportTest.msg(line);
            }
            isr.close();
        }
        catch (RuntimeException ex) {
            IOUtil.print((Throwable)ex);
        }
    }

    public void testDataStreaming() throws Exception {
        boolean COUNT = true;
        final CountDownLatch counter = new CountDownLatch(1);
        final ChannelInputStream[] inputStream = new ChannelInputStream[1];
        this.getAcceptor().addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof IContainerEvent) {
                    IContainerEvent e = (IContainerEvent)event;
                    ((IConnector)e.getDeltaElement()).addListener(new IListener(){

                        public void notifyEvent(IEvent event) {
                            IContainerEvent e;
                            if (event instanceof IContainerEvent && (e = (IContainerEvent)event).getDeltaKind() == IContainerDelta.Kind.ADDED) {
                                inputStream[0] = new ChannelInputStream((IChannel)e.getDeltaElement(), 2000L);
                                counter.countDown();
                            }
                        }
                    });
                }
            }
        });
        IChannel channel = this.getConnector().openChannel();
        TransportTest.assertEquals((boolean)true, (boolean)counter.await(2L, TimeUnit.SECONDS));
        ChannelOutputStream outputStream = new ChannelOutputStream(channel);
        DataOutputStream dataOutput = new DataOutputStream((OutputStream)outputStream);
        byte[] data = HugeData.getBytes();
        dataOutput.writeInt(data.length);
        dataOutput.write(data);
        dataOutput.flush();
        dataOutput.close();
        outputStream.flush();
        DataInputStream dataInput = new DataInputStream((InputStream)inputStream[0]);
        int size = dataInput.readInt();
        byte[] b = new byte[size];
        dataInput.read(b);
        dataInput.close();
        TransportTest.msg(new String(b));
    }

    public static final class TestProtocol
    extends Protocol<CountDownLatch> {
        public static final String TYPE = "test.protocol";

        public TestProtocol(CountDownLatch counter) {
            super(TYPE);
            this.setInfraStructure(counter);
        }

        public void handleBuffer(IBuffer buffer) {
            IOUtil.OUT().println("BUFFER ARRIVED");
            buffer.release();
            ((CountDownLatch)this.getInfraStructure()).countDown();
        }

        public static class ClientFactory
        extends ClientProtocolFactory {
            public ClientFactory() {
                super(TestProtocol.TYPE);
            }

            public TestProtocol create(String description) throws ProductCreationException {
                return new TestProtocol(null);
            }
        }

        public static class ServerFactory
        extends ServerProtocolFactory {
            private CountDownLatch counter;

            public ServerFactory(CountDownLatch counter) {
                super(TestProtocol.TYPE);
                this.counter = counter;
            }

            public TestProtocol create(String description) throws ProductCreationException {
                return new TestProtocol(this.counter);
            }
        }
    }
}

