/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.db;

import org.eclipse.emf.cdo.server.internal.lissome.db.Index;
import org.eclipse.emf.cdo.server.internal.lissome.db.Table;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;

public class CommitInfosTable
extends Table {
    protected IDBField time;
    protected IDBField branch;
    protected IDBField pointer;

    public CommitInfosTable(Index index) {
        super(index, "cdo_commits");
        this.time = this.table.addField("cdo_time", DBType.BIGINT);
        if (this.isSupportingBranches()) {
            this.branch = this.table.addField("cdo_branch", DBType.INTEGER);
        }
        this.pointer = this.table.addField("cdo_pointer", DBType.BIGINT);
        this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.time});
        if (this.isSupportingBranches()) {
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.branch});
        }
    }

    protected String sqlAddCommitInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this);
        builder.append(" (");
        builder.append(this.time);
        if (this.isSupportingBranches()) {
            builder.append(", ");
            builder.append(this.branch);
        }
        builder.append(", ");
        builder.append(this.pointer);
        builder.append(") VALUES (?, ?");
        if (this.isSupportingBranches()) {
            builder.append(", ?");
        }
        builder.append(")");
        return builder.toString();
    }

    protected String sqlLoadCommitInfos(boolean withBranch, boolean withStartTime, boolean withEndTime) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.pointer);
        builder.append(" FROM ");
        builder.append(this);
        boolean where = false;
        if (withBranch) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(this.branch);
            builder.append("=?");
            where = true;
        }
        if (withStartTime) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(this.time);
            builder.append(">=?");
            where = true;
        }
        if (withEndTime) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(this.time);
            builder.append("<=?");
            where = true;
        }
        builder.append(" ORDER BY ");
        builder.append(this.time);
        return builder.toString();
    }
}

