/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.provider.LMEditPlugin;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class CheckoutAction
extends LMAction<Baseline> {
    private String checkoutLabel;

    public CheckoutAction(IWorkbenchPage page, String text, Baseline baseline) {
        super(page, text == null ? "Checkout " + baseline.getTypeAndName() + INTERACTIVE : text, "Create a checkout for the selected " + LMEditPlugin.INSTANCE.getString("_UI_" + baseline.eClass().getName() + "_type").toLowerCase(), OM.getImageDescriptor("icons/checkout.gif"), "Create a checkout for the selected " + LMEditPlugin.INSTANCE.getString("_UI_" + baseline.eClass().getName() + "_type").toLowerCase() + ".", "icons/Checkout.png", baseline);
    }

    public CheckoutAction(IWorkbenchPage page, Baseline baseline) {
        this(page, null, baseline);
    }

    @Override
    protected void preRun() throws Exception {
        Baseline baseline = (Baseline)this.getContext();
        this.checkoutLabel = CheckoutAction.getCheckoutLabel(baseline);
        super.preRun();
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Checkout label:");
        Text checkoutLabelText = new Text(parent, 2052);
        checkoutLabelText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        checkoutLabelText.setText(this.checkoutLabel);
        checkoutLabelText.addModifyListener(e -> {
            this.checkoutLabel = checkoutLabelText.getText();
            this.validateDialog();
        });
        checkoutLabelText.setFocus();
    }

    @Override
    protected String doValidate(LMAction.LMDialog dialog) {
        if (this.checkoutLabel == null || this.checkoutLabel.isEmpty()) {
            return "A checkout label must be entered.";
        }
        return super.doValidate(dialog);
    }

    @Override
    protected void doRun(Baseline baseline, IProgressMonitor progressMonitor) throws Exception {
        CheckoutAction.checkout(baseline, progressMonitor);
    }

    public static String getCheckoutLabel(Baseline baseline) {
        return "Module " + baseline.getModule().getName() + " - " + baseline.getTypeAndName();
    }

    public static void checkout(Baseline baseline, IProgressMonitor monitor) throws Exception {
        String checkoutLabel = CheckoutAction.getCheckoutLabel(baseline);
        IAssemblyManager.INSTANCE.createDescriptor(checkoutLabel, baseline, monitor);
    }
}

