/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.internal.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.internal.ui.views.Net4jContainerItemProvider;
import org.eclipse.net4j.util.ui.actions.ToggleAction;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.net4j.util.ui.views.ManagedContainerItemProvider;
import org.eclipse.swt.graphics.Image;

public class Net4jContainerView
extends ContainerView {
    private final IAction showFactoriesAction = new ShowFactoriesAction();
    private final IAction decorateElementsAction = new DecorateElementsAction();

    public Net4jContainerItemProvider getItemProvider() {
        return (Net4jContainerItemProvider)super.getItemProvider();
    }

    protected Net4jContainerItemProvider createContainerItemProvider() {
        Net4jContainerItemProvider itemProvider = new Net4jContainerItemProvider();
        itemProvider.setShowFactories((Boolean)OM.PREF_SHOW_CONTAINER_FACTORIES.getValue());
        return itemProvider;
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    @Override
    protected ILabelDecorator createLabelDecorator() {
        return new ILabelDecorator(){

            public String decorateText(String text, Object element) {
                if (OM.PREF_DECORATE_CONTAINER_ELEMENTS.getValue() == Boolean.TRUE) {
                    Net4jContainerItemProvider itemProvider = Net4jContainerView.this.getItemProvider();
                    if (itemProvider.isShowFactories()) {
                        int elementCount;
                        if (element instanceof ManagedContainerItemProvider.Wrapper && (elementCount = ((ManagedContainerItemProvider.Wrapper)element).getElementCount()) > 0) {
                            text = String.valueOf(text) + "  [" + elementCount + "]";
                        }
                    } else {
                        String[] key = Net4jContainerView.this.getContainer().getElementKey(element);
                        if (key != null) {
                            String productGroup = key[0];
                            String factoryType = key[1];
                            String description = key[2];
                            String decoration = String.valueOf(productGroup) + ": " + factoryType;
                            if (!StringUtil.isEmpty((String)description)) {
                                decoration = String.valueOf(decoration) + "(" + description + ")";
                            }
                            text = String.valueOf(text) + "  " + decoration;
                        }
                    }
                }
                return text;
            }

            public Image decorateImage(Image image, Object element) {
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }
        };
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add(this.showFactoriesAction);
        manager.add(this.decorateElementsAction);
    }

    private final class DecorateElementsAction
    extends ToggleAction {
        public DecorateElementsAction() {
            super(Messages.getString("Net4jContainerView_1"), OM.getImageDescriptor("icons/decorate_container_element.png"), OM.PREF_DECORATE_CONTAINER_ELEMENTS);
        }

        @Override
        protected void run(boolean checked) {
            Net4jContainerView.this.refreshViewer(true);
        }
    }

    private final class ShowFactoriesAction
    extends ToggleAction {
        public ShowFactoriesAction() {
            super(Messages.getString("Net4jContainerView_0"), SharedIcons.getDescriptor((String)"obj16/factory"), OM.PREF_SHOW_CONTAINER_FACTORIES);
        }

        @Override
        protected void run(boolean checked) {
            Net4jContainerView.this.getItemProvider().setShowFactories(checked);
            Net4jContainerView.this.refreshViewer(true);
        }
    }
}

