/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchAdjustable;
import org.eclipse.emf.cdo.spi.common.lock.AbstractCDOLockChangeInfo;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;

public final class CDOLockChangeInfoImpl
extends AbstractCDOLockChangeInfo
implements CDOBranchAdjustable {
    private static final INotifier SOURCE = new Notifier();
    private static final long serialVersionUID = 1L;
    private CDOBranchPoint branchPoint;
    private final CDOLockOwner lockOwner;
    private final CDOLockDelta[] lockDeltas;
    private final CDOLockState[] lockStates;
    private final boolean isInvalidateAll;

    public CDOLockChangeInfoImpl(CDOBranchPoint branchPoint, CDOLockOwner lockOwner, Collection<CDOLockDelta> lockDeltas, Collection<CDOLockState> lockStates) {
        super(SOURCE);
        this.branchPoint = branchPoint;
        this.lockOwner = lockOwner;
        this.lockDeltas = lockDeltas.toArray(new CDOLockDelta[lockDeltas.size()]);
        this.lockStates = lockStates.toArray(new CDOLockState[lockStates.size()]);
        this.isInvalidateAll = false;
    }

    public CDOLockChangeInfoImpl() {
        super(null);
        this.lockOwner = null;
        this.lockDeltas = null;
        this.lockStates = null;
        this.isInvalidateAll = true;
    }

    @Override
    public void adjustBranches(CDOBranchManager newBranchManager) {
        CDOBranch branch;
        if (this.branchPoint != null && (branch = this.branchPoint.getBranch()) != null) {
            branch = newBranchManager.getBranch(branch.getID());
            this.branchPoint = branch.getPoint(this.branchPoint.getTimeStamp());
        }
    }

    @Override
    public CDOBranch getBranch() {
        return this.branchPoint == null ? null : this.branchPoint.getBranch();
    }

    @Override
    public long getTimeStamp() {
        return this.branchPoint == null ? 0L : this.branchPoint.getTimeStamp();
    }

    @Override
    public CDOLockOwner getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public CDOLockDelta[] getLockDeltas() {
        return this.lockDeltas;
    }

    @Override
    public CDOLockState[] getLockStates() {
        return this.lockStates;
    }

    @Override
    public boolean isInvalidateAll() {
        return this.isInvalidateAll;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CDOLockChangeInfo[branchPoint=");
        builder.append(this.branchPoint);
        if (this.isInvalidateAll) {
            builder.append(", invalidateAll");
        } else {
            builder.append(", deltas=");
            builder.append(Arrays.asList(this.lockDeltas));
        }
        builder.append("]");
        return builder.toString();
    }
}

