/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.repositories;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.internal.explorer.AbstractManager;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.internal.explorer.repositories.CloneCDORepository;
import org.eclipse.emf.cdo.internal.explorer.repositories.LocalCDORepository;
import org.eclipse.emf.cdo.internal.explorer.repositories.RemoteCDORepository;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.security.IPasswordCredentials;

public class CDORepositoryManagerImpl
extends AbstractManager<CDORepository>
implements CDORepositoryManager {
    public static final String SECURE_STORE_PATH = "/CDO/repositories";
    private static final String PROPERTIES_FILE = "repository.properties";
    private final Map<CDOSession, CDORepository> sessionMap = new ConcurrentHashMap<CDOSession, CDORepository>();

    public CDORepositoryManagerImpl(File folder) {
        super(CDORepository.class, folder);
    }

    @Override
    public String getPropertiesFileName() {
        return PROPERTIES_FILE;
    }

    @Override
    public CDORepository getRepository(String id) {
        return (CDORepository)this.getElement(id);
    }

    @Override
    public CDORepository getRepository(CDOSession session) {
        return this.sessionMap.get(session);
    }

    @Override
    public CDORepository getRepositoryByLabel(String label) {
        return (CDORepository)this.getElementByLabel(label);
    }

    @Override
    public CDORepository[] getRepositories() {
        return (CDORepository[])this.getElements();
    }

    @Override
    public CDORepository addRepository(Properties properties) {
        return this.addRepository(properties, null);
    }

    @Override
    public CDORepository addRepository(Properties properties, IPasswordCredentials credentials) {
        CDORepository repository = (CDORepository)this.newElement(properties);
        if (repository != null) {
            repository.setCredentials(credentials);
        }
        return repository;
    }

    public void disconnectUnusedRepositories() {
        CDORepository[] cDORepositoryArray = this.getRepositories();
        int n = cDORepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDORepository repository = cDORepositoryArray[n2];
            ((CDORepositoryImpl)repository).disconnectIfUnused();
            ++n2;
        }
    }

    public void fireRepositoryConnectionEvent(CDORepository repository, CDOSession session, boolean connected) {
        if (connected) {
            this.sessionMap.put(session, repository);
        } else {
            this.sessionMap.remove(session);
        }
        this.fireEvent(new RepositoryConnectionEventImpl(this, repository, connected));
    }

    @Override
    protected CDORepositoryImpl createElement(String type) {
        if ("remote".equals(type)) {
            return new RemoteCDORepository();
        }
        if ("clone".equals(type)) {
            return new CloneCDORepository();
        }
        if ("local".equals(type)) {
            return new LocalCDORepository();
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    protected void doDeactivate() throws Exception {
        CDORepository[] cDORepositoryArray = this.getRepositories();
        int n = cDORepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDORepository repository = cDORepositoryArray[n2];
            ((CDORepositoryImpl)repository).doDisconnect(true);
            ++n2;
        }
        super.doDeactivate();
    }

    private static final class RepositoryConnectionEventImpl
    extends Event
    implements CDORepositoryManager.RepositoryConnectionEvent {
        private static final long serialVersionUID = 1L;
        private final CDORepository repository;
        private final boolean connected;

        public RepositoryConnectionEventImpl(CDORepositoryManager repositoryManager, CDORepository repository, boolean connected) {
            super((INotifier)repositoryManager);
            this.repository = repository;
            this.connected = connected;
        }

        @Override
        public CDORepositoryManager getSource() {
            return (CDORepositoryManager)super.getSource();
        }

        @Override
        public CDORepository getRepository() {
            return this.repository;
        }

        @Override
        public boolean isConnected() {
            return this.connected;
        }
    }
}

