/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IStreamWrapper;

public class GZIPStreamWrapper
implements IStreamWrapper {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static final int DEFAULT_COMPRESSION_LEVEL = 1;
    private final int bufferSize;
    private final int compressionLevel;

    public GZIPStreamWrapper() {
        this(512, 1);
    }

    public GZIPStreamWrapper(int bufferSize, int compressionLevel) {
        this.bufferSize = bufferSize;
        this.compressionLevel = compressionLevel;
    }

    @Override
    public GZIPInputStream wrapInputStream(InputStream in) throws IOException {
        if (in instanceof GZIPInputStream) {
            return (GZIPInputStream)in;
        }
        return new GZIPInputStream(in, this.bufferSize);
    }

    @Override
    public GZIPOutputStream wrapOutputStream(OutputStream out) throws IOException {
        if (out instanceof GZIPOutputStream) {
            return (GZIPOutputStream)out;
        }
        return new GZIPOutputStream(out, this.bufferSize){
            {
                this.def.setLevel(GZIPStreamWrapper.this.compressionLevel);
            }
        };
    }

    @Override
    public void finishInputStream(InputStream in) throws IOException {
    }

    @Override
    public void finishOutputStream(OutputStream out) throws IOException {
        ((GZIPOutputStream)out).finish();
    }

    public static class Factory
    extends IStreamWrapper.Factory {
        public static final String TYPE = "gzip";

        public Factory() {
            super(TYPE);
        }

        @Override
        public IStreamWrapper create(String description) throws ProductCreationException {
            String[] properties;
            int bufferSize = 512;
            int compressionLevel = 1;
            String[] stringArray = properties = description.split(",");
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                String[] tokens = property.split("=");
                if (tokens.length == 2) {
                    String propertyName = tokens[0];
                    String propertyValue = tokens[1];
                    if ("bufferSize".equals(propertyName)) {
                        try {
                            bufferSize = Integer.valueOf(propertyValue);
                        }
                        catch (NumberFormatException ex) {
                            throw new ProductCreationException(ex);
                        }
                    }
                    if ("compressionLevel".equals(propertyName)) {
                        try {
                            compressionLevel = Integer.valueOf(propertyValue);
                        }
                        catch (NumberFormatException ex) {
                            throw new ProductCreationException(ex);
                        }
                    }
                }
                ++n2;
            }
            return new GZIPStreamWrapper(bufferSize, compressionLevel);
        }
    }
}

