/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.utils;

import java.util.StringTokenizer;
import org.eclipse.emf.eef.runtime.impl.utils.EEFRuntimeMessages;
import org.eclipse.swt.graphics.RGB;

public class StringTools {
    public static final String EMPTY_STRING = "";

    public static RGB toRGB(String s) {
        StringTokenizer st;
        if (s != null && (st = new StringTokenizer(s, EEFRuntimeMessages.StringTools_color_delim)).countTokens() == 3) {
            try {
                int red = Integer.parseInt(st.nextToken());
                int green = Integer.parseInt(st.nextToken());
                int blue = Integer.parseInt(st.nextToken());
                return new RGB(red, green, blue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isInt(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isFloat(String text) {
        try {
            Float.parseFloat(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isByte(String text) {
        try {
            Byte.parseByte(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDouble(String text) {
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String text) {
        try {
            Long.parseLong(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isShort(String text) {
        try {
            Short.parseShort(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String toL1Case(String name) {
        StringBuffer buf = new StringBuffer();
        buf.append(name.substring(0, 1).toLowerCase());
        buf.append(name.substring(1));
        return buf.toString();
    }

    public static String toU1Case(String name) {
        StringBuffer buf = new StringBuffer();
        buf.append(name.substring(0, 1).toUpperCase());
        buf.append(name.substring(1));
        return buf.toString();
    }
}

