/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets.referencestable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencesTableSettings
implements EEFEditorSettings {
    protected EObject source;
    protected EReference[] features;

    public ReferencesTableSettings(EObject source, EReference ... features) {
        this.source = source;
        this.features = features;
    }

    @Override
    public EObject getSource() {
        return this.source;
    }

    public void setSource(EObject source) {
        this.source = source;
    }

    @Override
    public EReference getLastReference() {
        return this.features[this.features.length - 1];
    }

    @Override
    public EClassifier getEType() {
        return this.features[this.features.length - 1].getEType();
    }

    @Override
    public boolean isAffectingFeature(EStructuralFeature feature) {
        return Arrays.asList(this.features).contains(feature);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.features.length) {
            EReference ref = this.features[i];
            builder.append(ref.getName());
            if (i < this.features.length - 1) {
                builder.append(" > ");
            }
            ++i;
        }
        return builder.toString();
    }

    public Object[] getValue() {
        Object value1;
        if (((EClass)this.features[0].eContainer()).isInstance((Object)this.source) && (value1 = this.source.eGet((EStructuralFeature)this.features[0])) != null) {
            if (this.features.length == 1) {
                Object[] objectArray;
                if (this.features[0].isMany()) {
                    objectArray = ((List)value1).toArray();
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = value1;
                }
                return objectArray;
            }
            if (this.features[0].isMany()) {
                ArrayList<String> result = new ArrayList<String>();
                for (EObject elem : (List)value1) {
                    if (this.features[1].isMany()) {
                        result.addAll((List)elem.eGet((EStructuralFeature)this.features[1]));
                        continue;
                    }
                    EObject value2 = (EObject)elem.eGet((EStructuralFeature)this.features[1]);
                    result.add(value2 == null ? "" : value2);
                }
                return result.toArray();
            }
            if (this.features[1].isMany()) {
                return ((List)((EObject)value1).eGet((EStructuralFeature)this.features[1])).toArray();
            }
            Object value2 = ((EObject)value1).eGet((EStructuralFeature)this.features[1]);
            return new Object[]{value2 == null ? "" : value2};
        }
        return new Object[0];
    }

    public void addToReference(EObject newValue) {
        Object value1 = this.source.eGet((EStructuralFeature)this.features[0]);
        if (this.features[0].isMany()) {
            this.addFirstMany((List)value1, newValue);
        } else {
            this.addFirstSingle((EObject)value1, newValue);
        }
    }

    protected void addFirstMany(List<EObject> ref1Values, EObject newValue) {
        if (this.features.length > 1) {
            if (this.features[1].isMany()) {
                this.addFirstManySecondMany(ref1Values, newValue);
            } else {
                this.addFirstManySecondSingle(ref1Values, newValue);
            }
        } else {
            ref1Values.add(newValue);
        }
    }

    protected void addFirstManySecondMany(List<EObject> ref1Values, EObject newValue) {
        throw new IllegalStateException("Ambigous case - Cannot process ModelNavigation with more than one multiple reference");
    }

    protected void addFirstManySecondSingle(List<EObject> ref1Values, EObject newValue) {
        EObject intermediate = EcoreUtil.create((EClass)this.features[0].getEReferenceType());
        intermediate.eSet((EStructuralFeature)this.features[1], (Object)newValue);
        ref1Values.add(intermediate);
    }

    protected void addFirstSingle(EObject ref1Value, EObject newValue) {
        if (this.features.length > 1) {
            if (this.features[1].isMany()) {
                this.addFirstSingleSecondMany(ref1Value, newValue);
            } else {
                this.addFirstSingleSecondSingle(ref1Value, newValue);
            }
        } else {
            this.source.eSet((EStructuralFeature)this.features[0], (Object)newValue);
        }
    }

    protected void addFirstSingleSecondMany(EObject ref1Value, EObject newValue) {
        if (ref1Value == null) {
            ref1Value = EcoreUtil.create((EClass)this.features[0].getEReferenceType());
            this.source.eSet((EStructuralFeature)this.features[0], (Object)ref1Value);
        }
        ((List)ref1Value.eGet((EStructuralFeature)this.features[1])).add(newValue);
    }

    protected void addFirstSingleSecondSingle(EObject ref1Value, EObject newValue) {
        throw new IllegalStateException("Ambigous case - Cannot process ModelNavigation without multiple reference");
    }

    public void setToReference(List<EObject> newValues) {
        Object value1 = this.source.eGet((EStructuralFeature)this.features[0]);
        if (this.features[0].isMany()) {
            this.setFirstMany((List)value1, newValues);
        } else {
            this.setFirstSingle((EObject)value1, newValues);
        }
    }

    protected void setFirstMany(List<EObject> ref1Values, List<EObject> newValues) {
        if (this.features.length > 1) {
            EReference ref2 = this.features[1];
            if (ref2.isMany()) {
                this.setFirstManySecondMany(ref1Values, newValues);
            } else {
                this.setFirstManySecondSingle(ref1Values, newValues);
            }
        } else {
            this.source.eSet((EStructuralFeature)this.features[0], newValues);
        }
    }

    protected void setFirstManySecondMany(List<EObject> ref1Values, List<EObject> newValues) {
        throw new IllegalStateException("Ambigous case - Cannot process ModelNavigation with more than one multiple reference");
    }

    protected void setFirstManySecondSingle(List<EObject> ref1Values, List<EObject> newValues) {
        ArrayList<EObject> todo = new ArrayList<EObject>(newValues);
        ArrayList<EObject> toremove = new ArrayList<EObject>();
        for (EObject ref1Value : ref1Values) {
            EObject ref2Value = (EObject)ref1Value.eGet((EStructuralFeature)this.features[1]);
            if (todo.contains(ref2Value)) {
                todo.remove(ref2Value);
                continue;
            }
            toremove.add(ref1Value);
        }
        for (EObject eObject : toremove) {
            ref1Values.remove(eObject);
        }
        for (EObject eObject : todo) {
            EObject intermediate = EcoreUtil.create((EClass)this.features[0].getEReferenceType());
            intermediate.eSet((EStructuralFeature)this.features[1], (Object)eObject);
            ref1Values.add(intermediate);
        }
    }

    protected void setFirstSingle(EObject ref1Value, List<EObject> newValues) {
        if (this.features.length > 1) {
            if (this.features[1].isMany()) {
                this.setFirstSingleSecondMany(ref1Value, newValues);
            } else {
                this.setFirstSingleSecondSingle(this.features[1], newValues);
            }
        } else {
            this.source.eSet((EStructuralFeature)this.features[0], newValues);
        }
    }

    protected void setFirstSingleSecondMany(EObject ref1Value, List<EObject> newValues) {
        if (ref1Value == null) {
            ref1Value = EcoreUtil.create((EClass)this.features[0].getEReferenceType());
            this.source.eSet((EStructuralFeature)this.features[0], (Object)ref1Value);
        }
        ref1Value.eSet((EStructuralFeature)this.features[1], newValues);
    }

    protected void setFirstSingleSecondSingle(Object value2, List<EObject> newValues) {
        throw new IllegalStateException("Ambigous case - Cannot process ModelNavigation without multiple reference");
    }

    public void removeFromReference(EObject valueToRemove) {
        EReference ref = this.features[0];
        Object value1 = this.source.eGet((EStructuralFeature)ref);
        if (ref.isMany()) {
            this.removeFirstMany((List)value1, valueToRemove);
        } else {
            this.removeFirstSingle((EObject)value1, valueToRemove);
        }
    }

    protected void removeFirstMany(List<EObject> value1, EObject valueToRemove) {
        if (this.features.length > 1) {
            EReference ref2 = this.features[1];
            if (ref2.isMany()) {
                this.removeFirstManySecondMany(value1, valueToRemove);
            } else {
                this.removeFirstManySecondSingle(value1, valueToRemove);
            }
        } else if (this.features[0].isContainment()) {
            EcoreUtil.delete((EObject)valueToRemove);
        } else {
            value1.remove(valueToRemove);
        }
    }

    protected void removeFirstManySecondMany(List<EObject> ref1Values, EObject valueToRemove) {
        throw new IllegalStateException("Ambigous case - Cannot process ModelNavigation with more than one multiple reference");
    }

    protected void removeFirstManySecondSingle(List<EObject> value1, EObject valueToRemove) {
        EObject elemToRemove = null;
        for (EObject elem : value1) {
            EObject elem2 = (EObject)elem.eGet((EStructuralFeature)this.features[1]);
            if (elem2 == null || !elem2.equals(valueToRemove)) continue;
            elemToRemove = elem;
        }
        if (this.features[0].isContainment()) {
            EcoreUtil.delete(elemToRemove);
        } else {
            value1.remove(elemToRemove);
        }
    }

    protected void removeFirstSingle(EObject value1, EObject valueToRemove) {
        if (this.features.length > 1) {
            Object value2 = value1.eGet((EStructuralFeature)this.features[1]);
            if (this.features[1].isMany()) {
                this.removeFirstSingleSecondMany((List)value2, valueToRemove);
            } else {
                this.removeFirstSingleSecondSingle();
            }
        } else if (this.features[0].isContainment()) {
            EcoreUtil.delete((EObject)valueToRemove);
        } else {
            this.source.eUnset((EStructuralFeature)this.features[0]);
        }
    }

    protected void removeFirstSingleSecondMany(List<EObject> value2, EObject valueToRemove) {
        if (this.features[1].isContainment()) {
            EcoreUtil.delete((EObject)valueToRemove);
        } else {
            value2.remove(valueToRemove);
        }
    }

    protected void removeFirstSingleSecondSingle() {
        if (this.features[0].isContainment()) {
            EcoreUtil.delete((EObject)((EObject)this.source.eGet((EStructuralFeature)this.features[0])));
        } else {
            this.source.eUnset((EStructuralFeature)this.features[0]);
        }
    }

    public boolean contains(EObject toCheck) {
        EReference ref = this.features[0];
        Object value1 = this.source.eGet((EStructuralFeature)ref);
        if (ref.isMany()) {
            if (this.features.length > 1) {
                EReference ref2 = this.features[1];
                if (ref2.isMany()) {
                    for (EObject elem : (List)value1) {
                        List value2 = (List)elem.eGet((EStructuralFeature)ref2);
                        if (!value2.contains(toCheck)) continue;
                        return true;
                    }
                    return false;
                }
                for (EObject elem : (List)value1) {
                    EObject elem2 = (EObject)elem.eGet((EStructuralFeature)ref2);
                    if (elem2 == null || !elem2.equals(toCheck)) continue;
                    return true;
                }
                return false;
            }
            return ((List)value1).contains(toCheck);
        }
        if (this.features.length > 1) {
            EReference ref2 = this.features[1];
            Object value2 = ((EObject)value1).eGet((EStructuralFeature)ref2);
            if (ref2.isMany()) {
                return ((List)value2).contains(toCheck);
            }
            return value2.equals(toCheck);
        }
        return value1.equals(toCheck);
    }

    @Override
    public Object choiceOfValues(AdapterFactory adapterFactory) {
        if (this.features.length == 1) {
            return EEFUtils.choiceOfValues(this.source, (EStructuralFeature)this.features[0]);
        }
        if (this.features.length > 1) {
            EObject tmp = EcoreUtil.create((EClass)((EClass)this.features[0].getEType()));
            this.source.eResource().getContents().add((Object)tmp);
            Object result = EEFUtils.choiceOfValues(tmp, (EStructuralFeature)this.features[1]);
            EcoreUtil.delete((EObject)tmp);
            return result;
        }
        return null;
    }

    public void move(int newIndex, EObject element) {
        Object value1 = this.source.eGet((EStructuralFeature)this.features[0]);
        if (this.features[0].isMany()) {
            this.moveFirstMany((EList<EObject>)((EList)value1), newIndex, element);
        } else {
            this.moveFirstSingle((EObject)value1, newIndex, element);
        }
    }

    protected void moveFirstMany(EList<EObject> ref1Values, int newIndex, EObject element) {
        if (this.features.length > 1) {
            if (this.features[1].isMany()) {
                this.moveFirstManySecondMany(ref1Values, newIndex, element);
            } else {
                this.moveFirstManySecondSingle(ref1Values, newIndex, element);
            }
        } else {
            ref1Values.move(newIndex, (Object)element);
        }
    }

    protected void moveFirstManySecondMany(EList<EObject> ref1Values, int newIndex, EObject element) {
        throw new IllegalStateException("Ambigous case - Cannot process ModelNavigation with more than one multiple reference");
    }

    protected void moveFirstManySecondSingle(EList<EObject> ref1Values, int newIndex, EObject element) {
        for (EObject eObject : ref1Values) {
            if (!eObject.eGet((EStructuralFeature)this.features[1]).equals(element)) continue;
            ref1Values.move(newIndex, (Object)eObject);
            return;
        }
    }

    protected void moveFirstSingle(EObject ref1Value, int newIndex, EObject element) {
        if (this.features.length > 1) {
            if (this.features[1].isMany()) {
                this.moveFirstSingleSecondMany(ref1Value, newIndex, element);
            } else {
                this.moveFirstSingleSecondSingle(ref1Value, newIndex, element);
            }
        } else {
            throw new IllegalStateException("Ambigous case - Cannot process move for ModelNavigation with one single reference");
        }
    }

    protected void moveFirstSingleSecondMany(EObject ref1Value, int newIndex, EObject element) {
        ((EList)ref1Value.eGet((EStructuralFeature)this.features[1])).move(newIndex, (Object)element);
    }

    protected void moveFirstSingleSecondSingle(EObject ref1Value, int newIndex, EObject element) {
        throw new IllegalStateException("Ambigous case - Cannot process ModelNavigation without multiple reference");
    }
}

