/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.source;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.mint.CodeGenStatus;
import org.eclipse.emf.mint.IMemberAnnotationManager;
import org.eclipse.emf.mint.MintCore;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class GeneratedMethodPropertyTester extends PropertyTester {

	private static final String GEN_SUFFIX = "Gen"; //$NON-NLS-1$

	private static final String PROP_IS_CUSTOMIZABLE_METHOD = "isCustomizableMethod"; //$NON-NLS-1$

	public boolean test(Object receiver, String property, Object[] args,
			Object expectedValue) {
		if (receiver instanceof IMethod
				&& PROP_IS_CUSTOMIZABLE_METHOD.equals(property)) {
			return Boolean.valueOf(isCustomizableMethod((IMethod) receiver))
					.equals(expectedValue);
		}

		return false;
	}

	public static boolean isCustomizableMethod(IMethod method) {
		if (method.isReadOnly())
			return false;

		IType type = method.getDeclaringType();
		if (type == null)
			return false;

		String genMethodName = method.getElementName() + GEN_SUFFIX;
		IMethod genMethod = type.getMethod(genMethodName, method
				.getParameterTypes());
		if (genMethod.exists())
			return false;

		IMemberAnnotationManager mgr = MintCore.getInstance()
				.getMemberAnnotationManager();
		if (mgr.getCodeGenStatus(method) == CodeGenStatus.GENERATED) {
			try {
				return type.isClass();
			} catch (JavaModelException e) {
				// ignore
			}
		}

		return false;
	}
}
