/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.SwingPropertyChangeSupport;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.FilterIteratorFactory;
import prefuse.data.util.Sort;
import prefuse.data.util.SortedTupleIterator;

public abstract class AbstractTupleSet
implements TupleSet {
    private CopyOnWriteArrayList m_tupleListeners;
    private HashMap m_props;
    private SwingPropertyChangeSupport m_propSupport;

    public Iterator tuples(Predicate filter) {
        if (filter == null) {
            return this.tuples();
        }
        return FilterIteratorFactory.tuples(this, filter);
    }

    public Iterator tuples(Predicate filter, Sort sort) {
        if (sort == null) {
            return this.tuples(filter);
        }
        Comparator c = sort.getComparator(this);
        return new SortedTupleIterator(this.tuples(filter), this.getTupleCount(), c);
    }

    public void addTupleSetListener(TupleSetListener tsl) {
        if (this.m_tupleListeners == null) {
            this.m_tupleListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_tupleListeners.contains(tsl)) {
            this.m_tupleListeners.add(tsl);
        }
    }

    public void removeTupleSetListener(TupleSetListener tsl) {
        if (this.m_tupleListeners != null) {
            this.m_tupleListeners.remove(tsl);
        }
    }

    protected void fireTupleEvent(Table t, int start, int end, int type) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] lstnrs = this.m_tupleListeners.toArray();
            Tuple[] tuples = new Tuple[end - start + 1];
            int i = 0;
            int r = start;
            while (r <= end) {
                tuples[i] = t.getTuple(r);
                ++r;
                ++i;
            }
            i = 0;
            while (i < lstnrs.length) {
                TupleSetListener tsl = (TupleSetListener)lstnrs[i];
                if (type == 1) {
                    tsl.tupleSetChanged(this, tuples, EMPTY_ARRAY);
                } else {
                    tsl.tupleSetChanged(this, EMPTY_ARRAY, tuples);
                }
                ++i;
            }
        }
    }

    protected void fireTupleEvent(Tuple t, int type) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] lstnrs = this.m_tupleListeners.toArray();
            Tuple[] ts = new Tuple[]{t};
            int i = 0;
            while (i < lstnrs.length) {
                TupleSetListener tsl = (TupleSetListener)lstnrs[i];
                if (type == 1) {
                    tsl.tupleSetChanged(this, ts, EMPTY_ARRAY);
                } else {
                    tsl.tupleSetChanged(this, EMPTY_ARRAY, ts);
                }
                ++i;
            }
        }
    }

    protected void fireTupleEvent(Tuple[] added, Tuple[] removed) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] lstnrs = this.m_tupleListeners.toArray();
            added = added == null ? EMPTY_ARRAY : added;
            removed = removed == null ? EMPTY_ARRAY : removed;
            int i = 0;
            while (i < lstnrs.length) {
                TupleSetListener tsl = (TupleSetListener)lstnrs[i];
                tsl.tupleSetChanged(this, added, removed);
                ++i;
            }
        }
    }

    public boolean isAddColumnSupported() {
        return false;
    }

    public void addColumns(Schema schema) {
        if (this.isAddColumnSupported()) {
            int i = 0;
            while (i < schema.getColumnCount()) {
                try {
                    this.addColumn(schema.getColumnName(i), schema.getColumnType(i), schema.getDefault(i));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void addColumn(String name, Class type, Object defaultValue) {
        throw new UnsupportedOperationException();
    }

    public void addColumn(String name, Class type) {
        throw new UnsupportedOperationException();
    }

    public void addColumn(String name, Expression expr) {
        throw new UnsupportedOperationException();
    }

    public void addColumn(String name, String expr) {
        throw new UnsupportedOperationException();
    }

    public void addPropertyChangeListener(PropertyChangeListener lstnr) {
        if (lstnr == null) {
            return;
        }
        if (this.m_propSupport == null) {
            this.m_propSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_propSupport.addPropertyChangeListener(lstnr);
    }

    public void addPropertyChangeListener(String key, PropertyChangeListener lstnr) {
        if (lstnr == null) {
            return;
        }
        if (this.m_propSupport == null) {
            this.m_propSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_propSupport.addPropertyChangeListener(key, lstnr);
    }

    public void removePropertyChangeListener(PropertyChangeListener lstnr) {
        if (lstnr == null) {
            return;
        }
        if (this.m_propSupport == null) {
            return;
        }
        this.m_propSupport.removePropertyChangeListener(lstnr);
    }

    public void removePropertyChangeListener(String key, PropertyChangeListener lstnr) {
        if (lstnr == null) {
            return;
        }
        if (this.m_propSupport == null) {
            return;
        }
        this.m_propSupport.removePropertyChangeListener(key, lstnr);
    }

    public void putClientProperty(String key, Object value) {
        Object prev = null;
        if (this.m_props == null && value == null) {
            return;
        }
        if (value == null) {
            prev = this.m_props.remove(key);
        } else {
            if (this.m_props == null) {
                this.m_props = new HashMap(2);
            }
            prev = this.m_props.put(key, value);
        }
        if (this.m_propSupport != null) {
            this.m_propSupport.firePropertyChange(key, prev, value);
        }
    }

    public Object getClientProperty(String key) {
        return this.m_props == null ? null : this.m_props.get(key);
    }
}

