/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.NullSelector;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

public class MultipleStringFileEditor
extends MultipleValueEditor<IElementSelector> {
    protected boolean allowBrowseWorkspace = true;
    protected boolean allowBrowseFileSystem = true;
    protected Button browseFileSystem;
    protected Button browseWorkspace;
    protected final List<String> filterNames;
    protected final List<String> filterExtensions;
    public static final String browseWorkspaceIcon = "icons/browse-workspace_12x12.png";
    public static final String browseFileSystemIcon = "icons/browse-filesystem_12x12.png";

    public MultipleStringFileEditor(Composite parent, int style) {
        super(parent, style, NullSelector.instance);
        this.setDirectCreation(true);
        this.filterNames = new LinkedList<String>();
        this.filterExtensions = new LinkedList<String>();
    }

    @Override
    protected void createListControls() {
        super.createListControls();
        this.add.dispose();
        this.edit.dispose();
        this.browseFileSystem = this.createButton(Activator.getDefault().getImageFromPlugin(browseFileSystemIcon), Messages.MultipleStringFileEditor_0);
        this.browseWorkspace = this.createButton(Activator.getDefault().getImageFromPlugin(browseWorkspaceIcon), Messages.MultipleStringFileEditor_1);
        this.browseWorkspace.moveAbove((Control)this.remove);
        this.browseFileSystem.moveAbove((Control)this.remove);
    }

    @Override
    public void setDirectCreation(boolean directCreation) {
        super.setDirectCreation(true);
    }

    @Override
    protected void updateControls() {
        this.remove.setEnabled(!this.readOnly);
        this.up.setEnabled(this.ordered && !this.readOnly);
        this.down.setEnabled(this.ordered && !this.readOnly);
        this.browseWorkspace.setEnabled(this.allowBrowseWorkspace && !this.readOnly);
        this.browseFileSystem.setEnabled(this.allowBrowseFileSystem && !this.readOnly);
    }

    public void allowBrowseWorkspace(boolean allowBrowseWorkspace) {
        this.allowBrowseWorkspace = allowBrowseWorkspace;
    }

    public void allowBrowseFileSystem(boolean allowBrowseFileSystem) {
        this.allowBrowseFileSystem = allowBrowseFileSystem;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget.isDisposed()) {
            return;
        }
        super.widgetSelected(e);
        if (e.widget == this.browseFileSystem) {
            this.browseFileSystem();
        } else if (e.widget == this.browseWorkspace) {
            this.browseWorkspace();
        }
    }

    protected void browseFileSystem() {
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setFilterExtensions(this.filterExtensions.toArray(new String[this.filterExtensions.size()]));
        dialog.setFilterNames(this.filterNames.toArray(new String[this.filterNames.size()]));
        if (dialog.open() != null) {
            ArrayList<CallSite> filePathList = new ArrayList<CallSite>(this.modelProperty.size() + dialog.getFileNames().length);
            filePathList.addAll((Collection<CallSite>)this.modelProperty);
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                filePathList.add((CallSite)((Object)(dialog.getFilterPath() + File.separator + fileName)));
                ++n2;
            }
            this.modelProperty.clear();
            this.modelProperty.addAll(filePathList);
            this.commit();
        }
    }

    protected void browseWorkspace() {
        Object[] result;
        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
        try {
            labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        ILabelProvider labelProvider = labelProviderService.getLabelProvider();
        ReferenceSelector selector = new ReferenceSelector();
        selector.setLabelProvider(labelProvider);
        WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
        contentProvider.setExtensionFilters(new LinkedHashMap<String, String>());
        int i = 0;
        while (i < Math.min(this.filterNames.size(), this.filterExtensions.size())) {
            contentProvider.addExtensionFilter(this.filterExtensions.get(i), this.filterNames.get(i));
            ++i;
        }
        selector.setContentProvider(contentProvider);
        MultipleValueSelectorDialog dialog = new MultipleValueSelectorDialog(this.getShell(), selector);
        if (this.labelText != null) {
            dialog.setTitle(this.labelText);
        }
        dialog.setLabelProvider(labelProvider);
        dialog.setOrdered(true);
        dialog.setUnique(true);
        selector.setUnique(true);
        int code = dialog.open();
        if (code == 0 && (result = dialog.getResult()).length > 0) {
            ArrayList<String> filePathResult = new ArrayList<String>(result.length + this.modelProperty.size());
            filePathResult.addAll((Collection<String>)this.modelProperty);
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (file instanceof IFile) {
                    filePathResult.add(FileUtil.getPath((IFile)file, false));
                }
                ++n2;
            }
            this.modelProperty.clear();
            this.modelProperty.addAll(filePathResult);
            this.commit();
        }
    }

    public void setFilters(String[] filterExtensions, String[] filterNames) {
        if (filterExtensions.length != filterNames.length) {
            Activator.log.warn(Messages.MultipleStringFileEditor_2);
        }
        this.setFilterNames(this.getFilterLabels(filterNames, filterExtensions));
        this.setFilterExtensions(filterExtensions);
    }

    protected String[] getFilterLabels(String[] filterNames, String[] filterExtensions) {
        int size = Math.min(filterNames.length, filterExtensions.length);
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = filterNames[i] + " (" + filterExtensions[i] + ")";
            ++i;
        }
        return filters;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions.clear();
        this.filterExtensions.addAll(Arrays.asList(filterExtensions));
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames.clear();
        this.filterNames.addAll(Arrays.asList(filterNames));
    }

    @Override
    public void dispose() {
        if (this.browseFileSystem != null) {
            this.browseFileSystem.removeSelectionListener((SelectionListener)this);
        }
        if (this.browseWorkspace != null) {
            this.browseWorkspace.removeSelectionListener((SelectionListener)this);
        }
        super.dispose();
    }
}

