/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;

public class CommandUtils {
    private CommandUtils() {
    }

    public static void dump(Object command) {
        CommandUtils.dump(command, System.err, 0);
    }

    public static void dump(Object command, Appendable sink) {
        CommandUtils.dump(command, sink, 0);
    }

    static Object unwrap(Object command) {
        if (command instanceof ICommandProxy) {
            return ((ICommandProxy)command).getICommand();
        }
        if (command instanceof CommandProxy) {
            return ((CommandProxy)command).getCommand();
        }
        if (command instanceof ICommandWrapper) {
            return ((ICommandWrapper)command).getWrappedCommand();
        }
        return command;
    }

    static void append(CharSequence text, Appendable sink) {
        try {
            sink.append(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void appendln(CharSequence text, Appendable sink) {
        try {
            sink.append(text).append(System.lineSeparator());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void appendln(Appendable sink) {
        try {
            sink.append(System.lineSeparator());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void dumpKind(Object command, Appendable sink, int depth) {
        String kind = command instanceof Command ? (command instanceof org.eclipse.emf.common.command.CompoundCommand ? "EMF*" : "EMF") : (command instanceof org.eclipse.gef.commands.Command ? (command instanceof CompoundCommand ? "GEF*" : "GEF") : (command instanceof ICommand ? (command instanceof ICompositeCommand ? "GMF*" : "GMF") : (command instanceof IUndoableOperation ? (command instanceof ICompositeOperation ? "UOP*" : "UOP") : "UNK")));
        StringBuilder buf = new StringBuilder(45);
        buf.append(Strings.padEnd((String)kind, (int)5, (char)' '));
        buf.append(Strings.repeat((String)"  ", (int)depth));
        String className = command.getClass().getName();
        buf.append(className.substring(className.lastIndexOf(46) + 1));
        buf.append(": ");
        CommandUtils.append(buf, sink);
    }

    static void dump(Object command, Appendable sink, int depth) {
        Object unwrapped = CommandUtils.unwrap(command);
        if (unwrapped != command) {
            CommandUtils.dump(unwrapped, sink, depth);
            return;
        }
        CommandUtils.dumpKind(command, sink, depth);
        if (command instanceof Command) {
            CommandUtils.dump0((Command)command, sink, depth);
        } else if (command instanceof org.eclipse.gef.commands.Command) {
            CommandUtils.dump0((org.eclipse.gef.commands.Command)command, sink, depth);
        } else if (command instanceof ICommand) {
            CommandUtils.dump0((ICommand)command, sink, depth);
        } else if (command instanceof IUndoableOperation) {
            CommandUtils.dump0((IUndoableOperation)command, sink, depth);
        } else {
            CommandUtils.appendln("<unknown>", sink);
        }
    }

    static void dump0(org.eclipse.gef.commands.Command command, Appendable sink, int depth) {
        CommandUtils.appendln(command.getLabel(), sink);
        if (command instanceof CompoundCommand) {
            int nextDepth = depth + 1;
            CompoundCommand compound = (CompoundCommand)command;
            compound.getCommands().stream().forEach(c -> CommandUtils.dump(c, sink, nextDepth));
        }
    }

    static void dump0(Command command, Appendable sink, int depth) {
        CommandUtils.appendln(command.getLabel(), sink);
        if (command instanceof org.eclipse.emf.common.command.CompoundCommand) {
            int nextDepth = depth + 1;
            org.eclipse.emf.common.command.CompoundCommand compound = (org.eclipse.emf.common.command.CompoundCommand)command;
            compound.getCommandList().stream().forEach(c -> CommandUtils.dump(c, sink, nextDepth));
        }
    }

    static void dump0(ICommand command, Appendable sink, int depth) {
        CommandUtils.appendln(command.getLabel(), sink);
        if (command instanceof ICompositeCommand) {
            int nextDepth = depth + 1;
            ICompositeCommand compound = (ICompositeCommand)command;
            compound.iterator().forEachRemaining(c -> CommandUtils.dump(c, sink, nextDepth));
        }
    }

    static void dump0(IUndoableOperation command, Appendable sink, int depth) {
        CommandUtils.appendln(command.getLabel(), sink);
        if (command instanceof ICompositeOperation) {
            int nextDepth = depth + 1;
            Collection<Object> children = Collections.emptyList();
            try {
                Field childrenField = command.getClass().getDeclaredField("children");
                Object childrenValue = childrenField.get(command);
                if (childrenValue != null) {
                    children = childrenValue instanceof Collection ? (Set<Object>)childrenValue : (childrenValue.getClass().isArray() ? Arrays.asList((Object[])childrenValue) : Collections.singleton(childrenValue));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            children.forEach(c -> CommandUtils.dump(c, sink, nextDepth));
        }
    }
}

