/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTCore.util;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.util.ExpressionsValidator;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.util.QVTBaseValidator;
import org.eclipse.qvt.declarative.ecore.QVTCore.Area;
import org.eclipse.qvt.declarative.ecore.QVTCore.Assignment;
import org.eclipse.qvt.declarative.ecore.QVTCore.BottomPattern;
import org.eclipse.qvt.declarative.ecore.QVTCore.CoreDomain;
import org.eclipse.qvt.declarative.ecore.QVTCore.CorePattern;
import org.eclipse.qvt.declarative.ecore.QVTCore.EnforcementMode;
import org.eclipse.qvt.declarative.ecore.QVTCore.EnforcementOperation;
import org.eclipse.qvt.declarative.ecore.QVTCore.GuardPattern;
import org.eclipse.qvt.declarative.ecore.QVTCore.Mapping;
import org.eclipse.qvt.declarative.ecore.QVTCore.PropertyAssignment;
import org.eclipse.qvt.declarative.ecore.QVTCore.QVTCorePackage;
import org.eclipse.qvt.declarative.ecore.QVTCore.RealizedVariable;
import org.eclipse.qvt.declarative.ecore.QVTCore.VariableAssignment;
import org.eclipse.qvt.declarative.ecore.QVTCore.operations.BottomPatternOperations;
import org.eclipse.qvt.declarative.ecore.QVTCore.operations.CorePatternOperations;
import org.eclipse.qvt.declarative.ecore.QVTCore.operations.PropertyAssignmentOperations;
import org.eclipse.qvt.declarative.ecore.QVTCore.operations.VariableAssignmentOperations;
import org.eclipse.qvt.declarative.ecore.QVTCore.util.QVTCorePlugin;
import org.eclipse.qvt.declarative.ecore.operations.EValidatorWithOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTCoreValidator
extends EObjectValidator
implements EValidatorWithOperations {
    public static final QVTCoreValidator INSTANCE = new QVTCoreValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.qvt.declarative.ecore.QVTCore";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected QVTBaseValidator qvtBaseValidator = QVTBaseValidator.INSTANCE;
    protected EcoreValidator ecoreValidator = EcoreValidator.INSTANCE;
    protected ExpressionsValidator expressionsValidator = ExpressionsValidator.INSTANCE;
    protected org.eclipse.ocl.ecore.util.EcoreValidator ecore_1Validator = org.eclipse.ocl.ecore.util.EcoreValidator.INSTANCE;
    protected Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> oclEnvironment;

    public String getDiagnosticSource() {
        return DIAGNOSTIC_SOURCE;
    }

    protected EPackage getEPackage() {
        return QVTCorePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateArea((Area)value, diagnostics, context);
            }
            case 1: {
                return this.validateAssignment((Assignment)value, diagnostics, context);
            }
            case 2: {
                return this.validateBottomPattern((BottomPattern)value, diagnostics, context);
            }
            case 3: {
                return this.validateCoreDomain((CoreDomain)value, diagnostics, context);
            }
            case 4: {
                return this.validateCorePattern((CorePattern)value, diagnostics, context);
            }
            case 5: {
                return this.validateEnforcementOperation((EnforcementOperation)value, diagnostics, context);
            }
            case 6: {
                return this.validateGuardPattern((GuardPattern)value, diagnostics, context);
            }
            case 7: {
                return this.validateMapping((Mapping)value, diagnostics, context);
            }
            case 8: {
                return this.validatePropertyAssignment((PropertyAssignment)value, diagnostics, context);
            }
            case 9: {
                return this.validateRealizedVariable((RealizedVariable)value, diagnostics, context);
            }
            case 10: {
                return this.validateVariableAssignment((VariableAssignment)value, diagnostics, context);
            }
            case 11: {
                return this.validateEnforcementMode((EnforcementMode)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateArea(Area area, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(area, diagnostics, context);
    }

    public boolean validateAssignment(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)assignment, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)assignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssignment_MappingIsEnforceable(assignment, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssignment_MappingIsEnforceable(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Area area;
        String message = null;
        if (assignment.isIsDefault() && (area = this.getArea((EObject)assignment)) != null && !this.getIsEnforceable(area)) {
            message = area instanceof Domain ? "Assignment can only be default within an enforceable domain" : "Assignment can only be default when some domain is enforceable";
        }
        if (message != null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, DIAGNOSTIC_SOURCE, 0, message, new Object[]{assignment}));
            }
            return false;
        }
        return true;
    }

    public boolean validateBottomPattern(BottomPattern bottomPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)bottomPattern, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)bottomPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)bottomPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)bottomPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)bottomPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)bottomPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)bottomPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validatePattern_NoVariableIsAFunctionParameter((Pattern)bottomPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCorePattern_VariableNamesAreUnique(bottomPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBottomPattern_RealizedVariableNamesAreUnique(bottomPattern, diagnostics, context);
        }
        return result;
    }

    public boolean validateBottomPattern_RealizedVariableNamesAreUnique(BottomPattern bottomPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return BottomPatternOperations.INSTANCE.checkRealizedVariableNamesAreUnique(bottomPattern, diagnostics, context);
    }

    public boolean validateCoreDomain(CoreDomain coreDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(coreDomain, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateENamedElement_WellFormedName((ENamedElement)coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validateDomain_TypedModelExistsWarning((Domain)coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validateDomain_TypedModelDefinedByTransformation((Domain)coreDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validateDomain_CheckableOrEnforceable((Domain)coreDomain, diagnostics, context);
        }
        return result;
    }

    public boolean validateCorePattern(CorePattern corePattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)corePattern, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)corePattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)corePattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)corePattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)corePattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)corePattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)corePattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validatePattern_NoVariableIsAFunctionParameter((Pattern)corePattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCorePattern_VariableNamesAreUnique(corePattern, diagnostics, context);
        }
        return result;
    }

    public boolean validateCorePattern_VariableNamesAreUnique(CorePattern corePattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return CorePatternOperations.INSTANCE.checkVariableNamesAreUnique(corePattern, diagnostics, context);
    }

    public boolean validateEnforcementOperation(EnforcementOperation enforcementOperation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)enforcementOperation, diagnostics, context);
    }

    public boolean validateGuardPattern(GuardPattern guardPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)guardPattern, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)guardPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)guardPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)guardPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)guardPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)guardPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)guardPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validatePattern_NoVariableIsAFunctionParameter((Pattern)guardPattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCorePattern_VariableNamesAreUnique(guardPattern, diagnostics, context);
        }
        return result;
    }

    public boolean validateMapping(Mapping mapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(mapping, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMapping_WellFormedName(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validateRule_OverridesIsCompatible((Rule)mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validateRule_OverridesDefinedByTransformation((Rule)mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.qvtBaseValidator.validateRule_DomainNamesAreUnique((Rule)mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMapping_DomainTypedModelsMatchModelParameters(mapping, diagnostics, context);
        }
        return result;
    }

    public boolean validateMapping_WellFormedName(Mapping mapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String message = null;
        if (mapping.getContext() != null) {
            if (mapping.getName() != null) {
                message = "Composed mapping '" + mapping.getName() + "' must be unnamed";
            }
        } else if (mapping.getName() == null) {
            message = "Non-composed mapping must be named";
        } else {
            return this.ecoreValidator.validateENamedElement_WellFormedName((ENamedElement)mapping, diagnostics, context);
        }
        if (message != null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, message, new Object[]{mapping}));
            }
            return false;
        }
        return true;
    }

    public boolean validateMapping_DomainTypedModelsMatchModelParameters(Mapping mapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePropertyAssignment(PropertyAssignment propertyAssignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)propertyAssignment, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)propertyAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)propertyAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)propertyAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)propertyAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)propertyAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)propertyAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssignment_MappingIsEnforceable(propertyAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePropertyAssignment_TypeIsConsistent(propertyAssignment, diagnostics, context);
        }
        return result;
    }

    public boolean validatePropertyAssignment_TypeIsConsistent(PropertyAssignment propertyAssignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return PropertyAssignmentOperations.INSTANCE.checkTypeIsConsistent(propertyAssignment, diagnostics, context);
    }

    public boolean validateRealizedVariable(RealizedVariable realizedVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)realizedVariable, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecore_1Validator.validateVariable_WellFormedName((Variable)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateETypedElement_ValidLowerBound((ETypedElement)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateETypedElement_ValidUpperBound((ETypedElement)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateETypedElement_ConsistentBounds((ETypedElement)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateETypedElement_ValidType((ETypedElement)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.expressionsValidator.validateVariable_checkInitType((org.eclipse.ocl.expressions.Variable)realizedVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRealizedVariable_MappingIsEnforceable(realizedVariable, diagnostics, context);
        }
        return result;
    }

    public boolean validateRealizedVariable_MappingIsEnforceable(RealizedVariable realizedVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String message = null;
        Area area = this.getArea((EObject)realizedVariable);
        if (area != null && !this.getIsEnforceable(area)) {
            EValidator.SubstitutionLabelProvider substitutionLabelProvider = (EValidator.SubstitutionLabelProvider)context.get(EValidator.SubstitutionLabelProvider.class);
            if (substitutionLabelProvider == null) {
                substitutionLabelProvider = Diagnostician.INSTANCE;
            }
            message = area instanceof Domain ? "Variable '" + substitutionLabelProvider.getObjectLabel((EObject)realizedVariable) + "' can only be realized within an enforceable domain" : "Variable '" + substitutionLabelProvider.getObjectLabel((EObject)realizedVariable) + "' can only be realized when some domain is enforceable";
        }
        if (message != null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, DIAGNOSTIC_SOURCE, 0, message, new Object[]{realizedVariable}));
            }
            return false;
        }
        return true;
    }

    public boolean validateVariableAssignment(VariableAssignment variableAssignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)variableAssignment, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)variableAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)variableAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)variableAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)variableAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)variableAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)variableAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssignment_MappingIsEnforceable(variableAssignment, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateVariableAssignment_TypeIsConsistent(variableAssignment, diagnostics, context);
        }
        return result;
    }

    public boolean validateVariableAssignment_TypeIsConsistent(VariableAssignment variableAssignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return VariableAssignmentOperations.INSTANCE.checkTypeIsConsistent(variableAssignment, diagnostics, context);
    }

    public boolean validateEnforcementMode(EnforcementMode enforcementMode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return QVTCorePlugin.INSTANCE;
    }

    public Area getArea(EObject object) {
        EObject o = object;
        while (o != null) {
            if (o instanceof Area) {
                return (Area)o;
            }
            o = o.eContainer();
        }
        return null;
    }

    public boolean getIsEnforceable(Area area) {
        if (area instanceof Domain) {
            return ((Domain)area).isIsEnforceable();
        }
        if (area instanceof Mapping) {
            for (Domain domain : ((Mapping)area).getDomain()) {
                if (!domain.isIsEnforceable()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getOclEnvironment(Map<Object, Object> context) {
        if (this.oclEnvironment == null) {
            Object env;
            if (context != null && (env = context.get(Environment.class)) instanceof Environment) {
                Environment env2;
                this.oclEnvironment = env2 = (Environment)env;
            }
            if (this.oclEnvironment == null) {
                this.oclEnvironment = new EcoreEnvironment(null){};
            }
        }
        return this.oclEnvironment;
    }
}

