/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class SyncUtil {
    private static final Logger LOG = Logger.getLogger(SyncUtil.class);
    @Inject(optional=true)
    private IWorkbench workbench;
    @Inject(optional=true)
    private IWorkspace workspace;

    public void totalSync(boolean saveAll, boolean useProgressDialog) throws InvocationTargetException, InterruptedException {
        this.totalSync(saveAll, useProgressDialog, true);
    }

    public void totalSync(final boolean saveAll, boolean useProgressDialog, boolean fork) throws InvocationTargetException, InterruptedException {
        if (Display.getCurrent() != null && this.workbench != null) {
            if (useProgressDialog) {
                this.workbench.getProgressService().run(fork, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SyncUtil.this.doReconcileAndBuild(saveAll, monitor);
                    }
                });
            } else {
                this.doReconcileAndBuild(saveAll, null);
            }
        }
    }

    private void doReconcileAndBuild(boolean saveAll, IProgressMonitor monitor) throws InterruptedException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
            this.reconcileAllEditors(this.workbench, saveAll, (IProgressMonitor)progress.newChild(1));
            if (progress.isCanceled()) {
                throw new InterruptedException();
            }
            this.waitForBuild((IProgressMonitor)progress.newChild(4));
            if (progress.isCanceled()) {
                throw new InterruptedException();
            }
            this.yieldToQueuedDisplayJobs((IProgressMonitor)progress.newChild(1));
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
    }

    public void totalSync(boolean saveAll) throws InvocationTargetException, InterruptedException {
        this.totalSync(saveAll, true);
    }

    public void reconcileAllEditors(IWorkbench workbench, boolean saveAll, final IProgressMonitor monitor) {
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    final IEditorPart editor = editorReference.getEditor(false);
                    if (editor != null) {
                        if (editor instanceof XtextEditor) {
                            this.waitForReconciler((XtextEditor)editor);
                        }
                        if (saveAll) {
                            Display display = workbench.getDisplay();
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (editor.isDirty()) {
                                        editor.doSave(monitor);
                                    }
                                }
                            });
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void waitForReconciler(XtextEditor editor) {
        try {
            editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                }
            });
            Job validationJob = editor.getAdapter(ValidationJob.class);
            if (validationJob != null) {
                validationJob.join();
            }
            editor.getDirtyStateEditorSupport().waitForUpdateEditorJob();
        }
        catch (OperationCanceledException validationJob) {
        }
        catch (OperationCanceledError validationJob) {
        }
        catch (InterruptedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void waitForBuild(IProgressMonitor monitor) {
        try {
            this.waitForJdtIndex(monitor);
            this.workspace.build(10, monitor);
        }
        catch (CoreException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    public void waitForJdtIndex(IProgressMonitor monitor) {
        JavaModelManager.getIndexManager().waitForIndex(true, monitor);
    }

    @Deprecated
    public void waitForAutoBuild(IProgressMonitor monitor) {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public void yieldToQueuedDisplayJobs(IProgressMonitor monitor) {
        this.yieldToQueuedDisplayJobs(monitor, 50000);
    }

    public void yieldToQueuedDisplayJobs(IProgressMonitor monitor, int maxJobsToYieldTo) {
        int count = 0;
        if (Display.getCurrent() != null) {
            while (count < maxJobsToYieldTo && Display.getCurrent().readAndDispatch()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++count;
            }
            if (count == maxJobsToYieldTo) {
                LOG.error((Object)("maxJobsToYieldTo probably exceeded. Worked: " + count));
            }
        }
    }
}

