/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.formatter;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.testing.formatter.FormatterTestHelper;
import org.eclipse.xtext.testing.formatter.FormatterTestRequest;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
public abstract class AbstractFormatterTest {
    @Inject
    @Extension
    protected FormatterTestHelper formatterTestHelper;

    protected void assertUnformattedEqualsFormatted(CharSequence formatterInput) {
        this.assertFormattedTo(formatterInput, null);
    }

    protected void assertUnformattedEqualsFormatted(CharSequence formatterInput, Consumer<MapBasedPreferenceValues> preferences) {
        this.assertFormattedTo(formatterInput, formatterInput, preferences);
    }

    protected void assertFormattedTo(CharSequence formatterInput, CharSequence formatterExpectation) {
        this.assertFormattedTo(formatterInput, formatterExpectation, null);
    }

    protected void assertFormattedTo(CharSequence formatterInput, CharSequence formatterExpectation, Consumer<MapBasedPreferenceValues> preferences) {
        this.formatterTestHelper.assertFormatted((Procedures.Procedure1<FormatterTestRequest>)((Procedures.Procedure1)request -> {
            request.setToBeFormatted(formatterInput);
            request.setExpectation(formatterExpectation);
            if (preferences != null) {
                preferences.accept(request.getOrCreateMapBasedPreferences());
            }
        }));
    }
}

