/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.command;

import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.InternalPasteDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.formula.FormulaDataProvider;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionException;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class FormulaPasteDataCommandHandler
extends InternalPasteDataCommandHandler {
    protected FormulaDataProvider dataProvider;

    public FormulaPasteDataCommandHandler(SelectionLayer selectionLayer, InternalCellClipboard clipboard, FormulaDataProvider dataProvider) {
        super(selectionLayer, clipboard);
        this.dataProvider = dataProvider;
    }

    @Override
    protected Object getPasteValue(ILayerCell cell, int pasteColumn, int pasteRow) {
        Object cellValue = cell.getDataValue();
        if (cellValue != null && this.dataProvider.getFormulaParser().isFunction(cellValue.toString())) {
            try {
                cellValue = this.dataProvider.getFormulaParser().updateReferences(cellValue.toString(), cell.getColumnPosition(), cell.getRowPosition(), pasteColumn, pasteRow);
            }
            catch (FunctionException e) {
                if (this.dataProvider.getErrorReporter() != null) {
                    this.dataProvider.getErrorReporter().addFormulaError(pasteColumn, pasteRow, e.getLocalizedMessage());
                }
                cellValue = e.getErrorMarkup();
            }
        }
        return cellValue;
    }

    @Override
    protected void preInternalPaste() {
        this.selectionLayer.doCommand(new DisableFormulaEvaluationCommand());
    }

    @Override
    protected void postInternalPaste() {
        this.selectionLayer.doCommand(new EnableFormulaEvaluationCommand());
    }
}

