/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.rangeslider;

import java.text.Format;
import java.util.EventListener;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class RangeSlider
extends Canvas {
    private static final byte NONE = 0;
    private static final byte UPPER = 1;
    private static final byte LOWER = 2;
    private static final byte BOTH = 3;
    private int minimum = 0;
    private int maximum = 100;
    private int lowerValue = 0;
    private int upperValue = 100;
    private final Image slider = SWTGraphicUtil.createImageFromFile((String)"images/slider-normal.png");
    private final Image sliderHover = SWTGraphicUtil.createImageFromFile((String)"images/slider-hover.png");
    private final Image sliderDrag = SWTGraphicUtil.createImageFromFile((String)"images/slider-drag.png");
    private final Image sliderSelected = SWTGraphicUtil.createImageFromFile((String)"images/slider-selected.png");
    private final Image vSlider = SWTGraphicUtil.createImageFromFile((String)"images/h-slider-normal.png");
    private final Image vSliderHover = SWTGraphicUtil.createImageFromFile((String)"images/h-slider-hover.png");
    private final Image vSliderDrag = SWTGraphicUtil.createImageFromFile((String)"images/h-slider-drag.png");
    private final Image vSliderSelected = SWTGraphicUtil.createImageFromFile((String)"images/h-slider-selected.png");
    private int orientation;
    private int increment = 1;
    private int pageIncrement = 10;
    private byte selectedElement;
    private byte priorSelectedElement;
    private boolean dragInProgress;
    private boolean upperHover;
    private boolean lowerHover;
    private int previousUpperValue;
    private int previousLowerValue;
    private int startDragUpperValue;
    private int startDragLowerValue;
    private Point startDragPoint;
    private boolean hasFocus;
    private final boolean isSmooth;
    private final boolean isFullSelection;
    private final boolean isHighQuality;
    private final boolean isOn;
    private int tickDivisions = 10;
    private int stride = 1;
    private float tickFactor;
    private Format toolTipFormatter;
    private String clientToolTipText;
    private StringBuffer toolTip;
    private Point coordUpper;
    private Point coordLower;

    public RangeSlider(Composite parent, int style) {
        super(parent, 0x20000000 | ((style & 0x800) == 2048 ? 2048 : 0));
        this.orientation = (style & 0x200) == 512 ? 512 : 256;
        this.isSmooth = (style & 0x10000) == 65536;
        this.isFullSelection = (style & 0x40000) == 262144;
        this.isHighQuality = (style & 2) == 2;
        this.isOn = (style & 1) == 1;
        this.selectedElement = (byte)(this.isFullSelection ? 3 : 2);
        this.addListener(12, event -> {
            SWTGraphicUtil.safeDispose((Resource)this.slider);
            SWTGraphicUtil.safeDispose((Resource)this.sliderHover);
            SWTGraphicUtil.safeDispose((Resource)this.sliderDrag);
            SWTGraphicUtil.safeDispose((Resource)this.sliderSelected);
            SWTGraphicUtil.safeDispose((Resource)this.vSlider);
            SWTGraphicUtil.safeDispose((Resource)this.vSliderHover);
            SWTGraphicUtil.safeDispose((Resource)this.vSliderDrag);
            SWTGraphicUtil.safeDispose((Resource)this.vSliderSelected);
        });
        this.addMouseListeners();
        this.addListener(11, event -> {
            if (this.isHighQuality) {
                this.setTickFactors();
            } else {
                this.tickFactor = ((float)(this.orientation == 256 ? this.getClientArea().width : this.getClientArea().height) - 20.0f) / (float)this.tickDivisions;
            }
        });
        this.addListener(15, e -> {
            this.hasFocus = true;
            this.redraw();
        });
        this.addListener(16, e -> {
            this.hasFocus = false;
            this.redraw();
        });
        this.addListener(1, event -> this.handleKeyDown(event));
        this.addPaintListener(event -> this.drawWidget(event));
    }

    protected void setTickFactors() {
        int breadth;
        int n = breadth = this.orientation == 256 ? this.getClientArea().width : this.getClientArea().height;
        if (breadth > 40) {
            this.setTickFactors((float)breadth - 20.0f);
        } else {
            this.tickDivisions = 0;
        }
    }

    protected void setTickFactors(float breadth) {
        int fullRange = this.maximum - this.minimum;
        int division = this.pageIncrement;
        this.tickDivisions = fullRange / division;
        float limit = Math.max(10.0f, breadth / 20.0f);
        while ((float)this.tickDivisions < limit && division > 2 && division % 2 == 0) {
            this.tickDivisions = fullRange / (division >>= 1);
        }
        if ((float)this.tickDivisions < limit) {
            division = this.increment;
            this.tickDivisions = fullRange / division;
            while ((float)this.tickDivisions < limit && division > 2 && division % 2 == 0) {
                this.tickDivisions = fullRange / (division >>= 1);
            }
        }
        if ((float)this.tickDivisions < limit && this.isSmooth) {
            division = 1;
            this.tickDivisions = fullRange;
        }
        this.stride = 1;
        if (this.tickDivisions > 0) {
            int range = fullRange - fullRange % division;
            float tickRange = breadth * (float)range / (float)fullRange;
            float pixelSize = tickRange / (float)range;
            limit = Math.max(10.0f, tickRange / 20.0f);
            while ((float)(this.tickDivisions / this.stride) > limit) {
                this.stride <<= 1;
            }
            this.tickFactor = pixelSize * (float)range / (float)this.tickDivisions;
            if (range != fullRange) {
                ++this.tickDivisions;
            }
        }
    }

    public int getStyle() {
        return super.getStyle() | this.orientation | (this.isSmooth ? 65536 : 0) | (this.isOn ? 1 : 0) | (this.isFullSelection ? 262144 : 0) | (this.isHighQuality ? 2 : 0);
    }

    private void addMouseListeners() {
        this.addListener(3, event -> this.handleMouseDown(event));
        this.addListener(4, event -> this.handleMouseUp(event));
        this.addListener(5, event -> this.handleMouseMove(event));
        this.addListener(37, event -> this.handleMouseWheel(event));
        this.addListener(32, event -> this.handleMouseHover(event));
        this.addListener(8, event -> this.handleMouseDoubleClick(event));
    }

    private void handleMouseDown(Event e) {
        this.selectKnobs(e);
        if (e.count == 1) {
            this.priorSelectedElement = this.selectedElement;
        }
        if (this.upperHover || this.lowerHover) {
            this.selectedElement = (byte)(this.isFullSelection && this.lowerHover && this.upperHover ? 3 : (this.lowerHover ? 2 : (this.upperHover ? 1 : (int)this.selectedElement)));
            this.dragInProgress = true;
            this.startDragLowerValue = this.previousLowerValue = this.lowerValue;
            this.startDragUpperValue = this.previousUpperValue = this.upperValue;
            this.startDragPoint = new Point(e.x, e.y);
        }
    }

    private void handleMouseUp(Event e) {
        if (this.dragInProgress) {
            this.startDragPoint = null;
            this.validateNewValues(e);
            this.dragInProgress = false;
            super.setToolTipText(this.clientToolTipText);
        }
    }

    private void validateNewValues(Event e) {
        if (this.upperValue != this.previousUpperValue || this.lowerValue != this.previousLowerValue) {
            if (!SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e)) {
                this.upperValue = this.previousUpperValue;
                this.lowerValue = this.previousLowerValue;
            }
            this.previousUpperValue = this.upperValue;
            this.previousLowerValue = this.lowerValue;
            this.redraw();
        }
    }

    private void handleMouseMove(Event e) {
        if (!this.dragInProgress) {
            boolean wasUpper = this.upperHover;
            boolean wasLower = this.lowerHover;
            this.selectKnobs(e);
            if (wasUpper != this.upperHover || wasLower != this.lowerHover) {
                this.redraw();
            }
        } else {
            int x = e.x;
            int y = e.y;
            if (this.orientation == 256) {
                if (this.selectedElement == 3) {
                    int diff = (int)((float)(this.startDragPoint.x - x) / this.computePixelSizeForHorizontalSlider()) + this.minimum;
                    int newUpper = this.startDragUpperValue - diff;
                    int newLower = this.startDragLowerValue - diff;
                    if (newUpper > this.maximum) {
                        newUpper = this.maximum;
                        newLower = this.maximum - (this.startDragUpperValue - this.startDragLowerValue);
                    } else if (newLower < this.minimum) {
                        newLower = this.minimum;
                        newUpper = this.minimum + this.startDragUpperValue - this.startDragLowerValue;
                    }
                    this.upperValue = newUpper;
                    this.lowerValue = newLower;
                    if (!this.isSmooth) {
                        this.lowerValue = (int)(Math.ceil(this.lowerValue / this.increment) * (double)this.increment) - this.increment;
                        this.upperValue = (int)(Math.ceil(this.upperValue / this.increment) * (double)this.increment) - this.increment;
                    }
                    this.handleToolTip(this.lowerValue, this.upperValue);
                } else if ((this.selectedElement & 1) != 0) {
                    this.upperValue = (int)Math.round(((double)x - 9.0) / (double)this.computePixelSizeForHorizontalSlider()) + this.minimum;
                    if (!this.isSmooth) {
                        this.upperValue = (int)(Math.ceil(this.upperValue / this.increment) * (double)this.increment) - this.increment;
                    }
                    this.checkUpperValue();
                    this.handleToolTip(this.upperValue);
                } else {
                    this.lowerValue = (int)Math.round(((double)x - 9.0) / (double)this.computePixelSizeForHorizontalSlider()) + this.minimum;
                    if (!this.isSmooth) {
                        this.lowerValue = (int)(Math.ceil(this.lowerValue / this.increment) * (double)this.increment) - this.increment;
                    }
                    this.checkLowerValue();
                    this.handleToolTip(this.lowerValue);
                }
            } else if (this.selectedElement == 3) {
                int diff = (int)((float)(this.startDragPoint.y - y) / this.computePixelSizeForVerticalSlider()) + this.minimum;
                int newUpper = this.startDragUpperValue - diff;
                int newLower = this.startDragLowerValue - diff;
                if (newUpper > this.maximum) {
                    newUpper = this.maximum;
                    newLower = this.maximum - (this.startDragUpperValue - this.startDragLowerValue);
                } else if (newLower < this.minimum) {
                    newLower = this.minimum;
                    newUpper = this.minimum + this.startDragUpperValue - this.startDragLowerValue;
                }
                this.upperValue = newUpper;
                this.lowerValue = newLower;
                if (!this.isSmooth) {
                    this.lowerValue = (int)(Math.ceil(this.lowerValue / this.increment) * (double)this.increment) - this.increment;
                    this.upperValue = (int)(Math.ceil(this.upperValue / this.increment) * (double)this.increment) - this.increment;
                }
                this.handleToolTip(this.lowerValue, this.upperValue);
            } else if ((this.selectedElement & 1) != 0) {
                this.upperValue = (int)Math.round(((double)y - 9.0) / (double)this.computePixelSizeForVerticalSlider()) + this.minimum;
                if (!this.isSmooth) {
                    this.upperValue = (int)(Math.ceil(this.upperValue / this.increment) * (double)this.increment) - this.increment;
                }
                this.checkUpperValue();
                this.handleToolTip(this.upperValue);
            } else {
                this.lowerValue = (int)Math.round(((double)y - 9.0) / (double)this.computePixelSizeForVerticalSlider()) + this.minimum;
                if (!this.isSmooth) {
                    this.lowerValue = (int)(Math.ceil(this.lowerValue / this.increment) * (double)this.increment) - this.increment;
                }
                this.checkLowerValue();
                this.handleToolTip(this.lowerValue);
            }
            if (this.isOn) {
                this.validateNewValues(e);
            } else {
                this.redraw();
            }
        }
    }

    private boolean isBetweenKnobs(int x, int y) {
        return this.orientation == 256 ? x < this.coordUpper.x && x > this.coordLower.x && y >= 9 && y <= 9 + this.getClientArea().height - 20 : y < this.coordUpper.y && y > this.coordLower.y && x >= 9 && x <= 9 + this.getClientArea().width - 20;
    }

    private void selectKnobs(Event e) {
        if (this.coordLower == null) {
            return;
        }
        Image img = this.orientation == 256 ? this.slider : this.vSlider;
        int x = e.x;
        int y = e.y;
        this.lowerHover = x >= this.coordLower.x && x <= this.coordLower.x + img.getBounds().width && y >= this.coordLower.y && y <= this.coordLower.y + img.getBounds().height;
        this.upperHover = ((e.stateMask & 0x60000) != 0 || !this.lowerHover) && x >= this.coordUpper.x && x <= this.coordUpper.x + img.getBounds().width && y >= this.coordUpper.y && y <= this.coordUpper.y + img.getBounds().height;
        this.lowerHover &= (e.stateMask & 0x40000) != 0 || !this.upperHover;
        if (!this.lowerHover && !this.upperHover && this.isFullSelection && this.isBetweenKnobs(x, y)) {
            this.upperHover = true;
            this.lowerHover = true;
        }
    }

    private int getCursorValue(int x, int y) {
        int value = -1;
        Rectangle clientArea = this.getClientArea();
        if (this.orientation == 256) {
            if (x < 9 + clientArea.width - 20 && x >= 9 && y >= 9 && y <= 9 + clientArea.height - 20) {
                value = (int)Math.round(((double)x - 9.0) / (double)this.computePixelSizeForHorizontalSlider()) + this.minimum;
            }
        } else if (y < 9 + clientArea.height - 20 && y >= 9 && x >= 9 && x <= 9 + clientArea.width - 20) {
            value = (int)Math.round(((double)y - 9.0) / (double)this.computePixelSizeForVerticalSlider()) + this.minimum;
        }
        return value;
    }

    private void handleMouseDoubleClick(Event e) {
        int value = this.getCursorValue(e.x, e.y);
        if (value >= 0) {
            this.selectedElement = this.priorSelectedElement;
            if (value > this.upperValue) {
                if (this.selectedElement == 3) {
                    this.lowerValue += value - this.upperValue;
                    this.upperValue = value;
                } else if ((this.selectedElement & 1) != 0) {
                    this.upperValue = value;
                } else if ((this.selectedElement & 2) != 0) {
                    int diff = this.upperValue - this.lowerValue;
                    if (value + diff > this.maximum) {
                        this.upperValue = this.maximum;
                        this.lowerValue = this.maximum - diff;
                    } else {
                        this.upperValue = value + diff;
                        this.lowerValue = value;
                    }
                }
            } else if (value < this.lowerValue) {
                if (this.selectedElement == 3) {
                    this.upperValue += value - this.lowerValue;
                    this.lowerValue = value;
                } else if ((this.selectedElement & 2) != 0) {
                    this.lowerValue = value;
                } else if ((this.selectedElement & 1) != 0) {
                    int diff = this.upperValue - this.lowerValue;
                    if (value - diff < this.minimum) {
                        this.lowerValue = this.minimum;
                        this.upperValue = this.minimum + diff;
                    } else {
                        this.upperValue = value;
                        this.lowerValue = value - diff;
                    }
                }
            } else if (value > this.lowerValue && value < this.upperValue && this.selectedElement != 3) {
                if ((this.selectedElement & 2) != 0) {
                    this.lowerValue = value;
                } else if ((this.selectedElement & 1) != 0) {
                    this.upperValue = value;
                }
            }
            this.validateNewValues(e);
        }
    }

    private void handleToolTip(int ... values) {
        if (this.toolTipFormatter != null) {
            try {
                if (values.length == 1) {
                    this.toolTip.setLength(0);
                    this.toolTipFormatter.format(values[0], this.toolTip, null);
                    super.setToolTipText(this.toolTip.toString());
                } else if (values.length == 2) {
                    this.toolTip.setLength(0);
                    this.toolTipFormatter.format(values[0], this.toolTip, null);
                    this.toolTip.append(" \u2194 ");
                    this.toolTipFormatter.format(values[1], this.toolTip, null);
                    super.setToolTipText(this.toolTip.toString());
                }
            }
            catch (IllegalArgumentException ex) {
                super.setToolTipText(this.clientToolTipText);
            }
        }
    }

    private void handleMouseHover(Event e) {
        if (!this.dragInProgress && this.toolTipFormatter != null) {
            int value = this.getCursorValue(e.x, e.y);
            if (value >= 0) {
                try {
                    this.toolTip.setLength(0);
                    this.toolTipFormatter.format(value, this.toolTip, null);
                    super.setToolTipText(this.toolTip.toString());
                }
                catch (IllegalArgumentException ex) {
                    super.setToolTipText(this.clientToolTipText);
                }
            } else {
                super.setToolTipText(this.clientToolTipText);
            }
        }
    }

    public void setToolTipFormatter(Format formatter) {
        this.toolTip = formatter != null ? new StringBuffer() : null;
        this.toolTipFormatter = formatter;
    }

    public void setToolTipText(String string) {
        this.clientToolTipText = string;
        super.setToolTipText(this.clientToolTipText);
    }

    private void handleMouseWheel(Event e) {
        if (this.selectedElement == 0 || this.dragInProgress) {
            e.doit = false;
            return;
        }
        this.previousLowerValue = this.lowerValue;
        this.previousUpperValue = this.upperValue;
        int amount = this.increment * ((e.stateMask & 0x20000) != 0 ? 10 : ((e.stateMask & 0x40000) != 0 ? 2 : 1));
        if (this.selectedElement == 3) {
            int newLower = this.lowerValue + e.count * amount;
            int newUpper = this.upperValue + e.count * amount;
            if (newUpper > this.maximum) {
                newUpper = this.maximum;
                newLower = this.maximum - (this.upperValue - this.lowerValue);
            } else if (newLower < this.minimum) {
                newLower = this.minimum;
                newUpper = this.minimum + this.upperValue - this.lowerValue;
            }
            this.upperValue = newUpper;
            this.lowerValue = newLower;
        } else if ((this.selectedElement & 2) != 0) {
            this.lowerValue += e.count * amount;
            this.checkLowerValue();
        } else {
            this.upperValue += e.count * amount;
            this.checkUpperValue();
        }
        this.validateNewValues(e);
        e.doit = false;
    }

    private void checkLowerValue() {
        if (this.lowerValue < this.minimum) {
            this.lowerValue = this.minimum;
        }
        if (this.lowerValue > this.maximum) {
            this.lowerValue = this.maximum;
        }
        if (this.lowerValue > this.upperValue) {
            this.lowerValue = this.upperValue;
        }
    }

    private void checkUpperValue() {
        if (this.upperValue < this.minimum) {
            this.upperValue = this.minimum;
        }
        if (this.upperValue > this.maximum) {
            this.upperValue = this.maximum;
        }
        if (this.upperValue < this.lowerValue) {
            this.upperValue = this.lowerValue;
        }
    }

    private void drawWidget(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        e.gc.setAdvanced(true);
        e.gc.setAntialias(1);
        if (this.orientation == 256) {
            this.drawHorizontalRangeSlider(e.gc);
        } else {
            this.drawVerticalRangeSlider(e.gc);
        }
    }

    private void drawHorizontalRangeSlider(GC gc) {
        this.drawBackgroundHorizontal(gc);
        this.drawBarsHorizontal(gc);
        if (this.lowerHover || (this.selectedElement & 2) != 0) {
            this.coordUpper = this.drawHorizontalKnob(gc, this.upperValue, true);
            this.coordLower = this.drawHorizontalKnob(gc, this.lowerValue, false);
        } else {
            this.coordLower = this.drawHorizontalKnob(gc, this.lowerValue, false);
            this.coordUpper = this.drawHorizontalKnob(gc, this.upperValue, true);
        }
    }

    private void drawBackgroundHorizontal(GC gc) {
        Rectangle clientArea = this.getClientArea();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(clientArea);
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        gc.drawRoundRectangle(9, 9, clientArea.width - 20, clientArea.height - 20, 3, 3);
        float pixelSize = this.computePixelSizeForHorizontalSlider();
        int startX = (int)(pixelSize * (float)this.lowerValue);
        int endX = (int)(pixelSize * (float)this.upperValue);
        if (this.isEnabled()) {
            gc.setBackground(this.getForeground());
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(15));
        }
        gc.fillRectangle(12 + startX, 9, endX - startX - 6, clientArea.height - 20);
    }

    private float computePixelSizeForHorizontalSlider() {
        return ((float)this.getClientArea().width - 20.0f) / (float)(this.maximum - this.minimum);
    }

    private void drawBarsHorizontal(GC gc) {
        Rectangle clientArea = this.getClientArea();
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        int i = this.stride;
        while (i < this.tickDivisions) {
            int x = (int)(9.0f + this.tickFactor * (float)i);
            gc.drawLine(x, 4, x, 7);
            gc.drawLine(x, clientArea.height - 6, x, clientArea.height - 9);
            i += this.stride;
        }
    }

    private Point drawHorizontalKnob(GC gc, int value, boolean upper) {
        float pixelSize = this.computePixelSizeForHorizontalSlider();
        int x = (int)(pixelSize * (float)value);
        Image image = upper ? (this.upperHover ? (this.dragInProgress || (this.selectedElement & 1) != 0 ? this.sliderDrag : this.sliderHover) : ((this.selectedElement & 1) != 0 && !this.lowerHover ? (this.hasFocus ? this.sliderSelected : this.sliderHover) : this.slider)) : (this.lowerHover ? (this.dragInProgress || (this.selectedElement & 2) != 0 ? this.sliderDrag : this.sliderHover) : ((this.selectedElement & 2) != 0 && !this.upperHover ? (this.hasFocus ? this.sliderSelected : this.sliderHover) : this.slider));
        if (this.isEnabled()) {
            gc.drawImage(image, x + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
        } else {
            Image temp = new Image((Device)this.getDisplay(), image, 1);
            gc.drawImage(temp, x + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
            temp.dispose();
        }
        return new Point(x + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
    }

    private void drawVerticalRangeSlider(GC gc) {
        this.drawBackgroundVertical(gc);
        this.drawBarsVertical(gc);
        if (this.lowerHover || (this.selectedElement & 2) != 0) {
            this.coordUpper = this.drawVerticalKnob(gc, this.upperValue, true);
            this.coordLower = this.drawVerticalKnob(gc, this.lowerValue, false);
        } else {
            this.coordLower = this.drawVerticalKnob(gc, this.lowerValue, false);
            this.coordUpper = this.drawVerticalKnob(gc, this.upperValue, true);
        }
    }

    private void drawBackgroundVertical(GC gc) {
        Rectangle clientArea = this.getClientArea();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(clientArea);
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        gc.drawRoundRectangle(9, 9, clientArea.width - 20, clientArea.height - 20, 3, 3);
        float pixelSize = this.computePixelSizeForVerticalSlider();
        int startY = (int)(pixelSize * (float)this.lowerValue);
        int endY = (int)(pixelSize * (float)this.upperValue);
        if (this.isEnabled()) {
            gc.setBackground(this.getForeground());
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(15));
        }
        gc.fillRectangle(9, 12 + startY, clientArea.width - 20, endY - startY - 6);
    }

    private float computePixelSizeForVerticalSlider() {
        return ((float)this.getClientArea().height - 20.0f) / (float)(this.maximum - this.minimum);
    }

    private void drawBarsVertical(GC gc) {
        Rectangle clientArea = this.getClientArea();
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        int i = this.stride;
        while (i < this.tickDivisions) {
            int y = (int)(9.0f + this.tickFactor * (float)i);
            gc.drawLine(4, y, 7, y);
            gc.drawLine(clientArea.width - 6, y, clientArea.width - 9, y);
            i += this.stride;
        }
    }

    private Point drawVerticalKnob(GC gc, int value, boolean upper) {
        float pixelSize = this.computePixelSizeForVerticalSlider();
        int y = (int)(pixelSize * (float)value);
        Image image = upper ? (this.upperHover ? (this.dragInProgress || (this.selectedElement & 1) != 0 ? this.vSliderDrag : this.vSliderHover) : ((this.selectedElement & 1) != 0 && !this.lowerHover ? (this.hasFocus ? this.vSliderSelected : this.vSliderHover) : this.vSlider)) : (this.lowerHover ? (this.dragInProgress || (this.selectedElement & 2) != 0 ? this.vSliderDrag : this.vSliderHover) : ((this.selectedElement & 2) != 0 && !this.upperHover ? (this.hasFocus ? this.vSliderSelected : this.vSliderHover) : this.vSlider));
        if (this.isEnabled()) {
            gc.drawImage(image, this.getClientArea().width / 2 - 8, y + 4);
        } else {
            Image temp = new Image((Device)this.getDisplay(), image, 1);
            gc.drawImage(temp, this.getClientArea().width / 2 - 8, y + 4);
            temp.dispose();
        }
        return new Point(this.getClientArea().width / 2 - 8, y + 4);
    }

    private void moveCursorPosition(int xDelta, int yDelta) {
        Point cursorPosition = this.getDisplay().getCursorLocation();
        cursorPosition.x += xDelta;
        cursorPosition.y += yDelta;
        this.getDisplay().setCursorLocation(cursorPosition);
    }

    private void handleKeyDown(Event event) {
        int accelerator;
        int n = (event.stateMask & 0x20000) != 0 ? 10 : (accelerator = (event.stateMask & 0x40000) != 0 ? 2 : 1);
        if (this.dragInProgress) {
            switch (event.keyCode) {
                case 27: {
                    this.startDragPoint = null;
                    this.upperValue = this.startDragUpperValue;
                    this.lowerValue = this.startDragLowerValue;
                    this.validateNewValues(event);
                    this.dragInProgress = false;
                    if (!this.isOn) {
                        this.redraw();
                    }
                    event.doit = false;
                    break;
                }
                case 0x1000001: {
                    accelerator = this.orientation == 256 ? -accelerator : accelerator;
                }
                case 0x1000003: {
                    if (this.orientation == 512) {
                        this.moveCursorPosition(0, -accelerator);
                    } else {
                        this.moveCursorPosition(-accelerator, 0);
                    }
                    event.doit = false;
                    break;
                }
                case 0x1000002: {
                    accelerator = this.orientation == 256 ? -accelerator : accelerator;
                }
                case 0x1000004: {
                    if (this.orientation == 512) {
                        this.moveCursorPosition(0, accelerator);
                    } else {
                        this.moveCursorPosition(accelerator, 0);
                    }
                    event.doit = false;
                }
            }
            return;
        }
        this.previousLowerValue = this.lowerValue;
        this.previousUpperValue = this.upperValue;
        if (this.selectedElement == 0) {
            this.selectedElement = (byte)2;
        }
        switch (event.keyCode) {
            case 0x1000007: {
                if (this.selectedElement == 3) {
                    if ((event.stateMask & 0x20000) != 0) {
                        this.lowerValue = this.maximum - (this.upperValue - this.lowerValue);
                        this.upperValue = this.maximum;
                        break;
                    }
                    this.upperValue = this.minimum + this.upperValue - this.lowerValue;
                    this.lowerValue = this.minimum;
                    break;
                }
                if ((this.selectedElement & 1) != 0) {
                    this.upperValue = this.maximum;
                    break;
                }
                this.lowerValue = this.minimum;
                break;
            }
            case 0x1000008: {
                if (this.selectedElement == 3) {
                    if ((event.stateMask & 0x20000) != 0) {
                        this.upperValue = this.minimum + this.upperValue - this.lowerValue;
                        this.lowerValue = this.minimum;
                        break;
                    }
                    this.lowerValue = this.maximum - (this.upperValue - this.lowerValue);
                    this.upperValue = this.maximum;
                    break;
                }
                if ((this.selectedElement & 1) != 0) {
                    this.upperValue = this.lowerValue;
                    break;
                }
                this.lowerValue = this.upperValue;
                break;
            }
            case 0x1000005: {
                int n2 = accelerator = this.orientation == 256 ? -accelerator : accelerator;
                if (this.selectedElement == 3) {
                    this.translateValues(this.pageIncrement * -accelerator);
                    break;
                }
                if ((this.selectedElement & 1) != 0) {
                    this.upperValue -= this.pageIncrement * accelerator;
                    break;
                }
                this.lowerValue -= this.pageIncrement * accelerator;
                break;
            }
            case 0x1000006: {
                int n3 = accelerator = this.orientation == 256 ? -accelerator : accelerator;
                if (this.selectedElement == 3) {
                    this.translateValues(this.pageIncrement * accelerator);
                    break;
                }
                if ((this.selectedElement & 1) != 0) {
                    this.upperValue += this.pageIncrement * accelerator;
                    break;
                }
                this.lowerValue += this.pageIncrement * accelerator;
                break;
            }
            case 0x1000002: {
                accelerator = this.orientation == 256 ? -accelerator : accelerator;
            }
            case 0x1000004: {
                if (this.selectedElement == 3) {
                    this.translateValues(accelerator * this.increment);
                    break;
                }
                if ((this.selectedElement & 1) != 0) {
                    this.upperValue += accelerator * this.increment;
                    break;
                }
                this.lowerValue += accelerator * this.increment;
                break;
            }
            case 0x1000001: {
                accelerator = this.orientation == 256 ? -accelerator : accelerator;
            }
            case 0x1000003: {
                if (this.selectedElement == 3) {
                    this.translateValues(-accelerator * this.increment);
                    break;
                }
                if ((this.selectedElement & 1) != 0) {
                    this.upperValue -= accelerator * this.increment;
                    break;
                }
                this.lowerValue -= accelerator * this.increment;
                break;
            }
            case 9: {
                boolean next;
                boolean bl = next = (event.stateMask & 0x20000) == 0;
                if (next && (this.selectedElement & 2) != 0) {
                    this.selectedElement = this.isFullSelection && this.selectedElement == 2 ? 3 : 1;
                    this.redraw();
                } else if (!next && (this.selectedElement & 1) != 0) {
                    this.selectedElement = (byte)(this.isFullSelection && this.selectedElement == 1 ? 3 : 2);
                    this.redraw();
                } else {
                    this.traverse(next ? 16 : 8);
                }
                return;
            }
        }
        if (this.previousLowerValue != this.lowerValue || this.previousUpperValue != this.upperValue) {
            if (this.selectedElement == 3) {
                this.checkLowerValue();
                this.checkUpperValue();
            } else if ((this.selectedElement & 1) != 0) {
                this.checkUpperValue();
            } else {
                this.checkLowerValue();
            }
            this.validateNewValues(event);
        }
    }

    private void translateValues(int amount) {
        int newLower = this.lowerValue + amount;
        int newUpper = this.upperValue + amount;
        if (newUpper > this.maximum) {
            newUpper = this.maximum;
            newLower = this.maximum - (this.upperValue - this.lowerValue);
        } else if (newLower < this.minimum) {
            newLower = this.minimum;
            newUpper = this.minimum + this.upperValue - this.lowerValue;
        }
        this.upperValue = newUpper;
        this.lowerValue = newLower;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13});
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        this.checkWidget();
        if (this.orientation == 256) {
            width = wHint < 100 ? 100 : wHint;
            height = hHint < 30 ? 30 : hHint;
        } else {
            width = wHint < 30 ? 30 : wHint;
            height = hHint < 100 ? 100 : hHint;
        }
        return new Point(width, height);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getLowerValue() {
        this.checkWidget();
        return this.lowerValue;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int[] getSelection() {
        this.checkWidget();
        int[] selection = new int[]{this.lowerValue, this.upperValue};
        return selection;
    }

    public int getUpperValue() {
        this.checkWidget();
        return this.upperValue;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        this.increment = increment;
        if (this.isHighQuality) {
            this.setTickFactors();
        }
        this.redraw();
    }

    public void setLowerValue(int value) {
        this.setSelection(value, this.upperValue);
    }

    public void setMaximum(int value) {
        this.setExtrema(this.minimum, value);
    }

    public void setMinimum(int value) {
        this.setExtrema(value, this.maximum);
    }

    public void setExtrema(int min, int max) {
        this.checkWidget();
        if (min >= 0 && min < max && (min != this.minimum || max != this.maximum)) {
            this.minimum = min;
            this.maximum = max;
            if (this.lowerValue < this.minimum) {
                this.lowerValue = this.minimum;
            } else if (this.lowerValue > this.maximum) {
                this.lowerValue = this.maximum;
            }
            if (this.upperValue < this.minimum) {
                this.upperValue = this.minimum;
            } else if (this.upperValue > this.maximum) {
                this.upperValue = this.maximum;
            }
            if (this.isHighQuality) {
                this.setTickFactors();
            }
            this.redraw();
        }
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        this.pageIncrement = pageIncrement;
        if (this.isHighQuality) {
            this.setTickFactors();
        }
        this.redraw();
    }

    public void setSelection(int[] values) {
        if (values.length == 2) {
            this.setSelection(values[0], values[1]);
        }
    }

    public void setSelection(int lowerValue, int upperValue) {
        this.checkWidget();
        if (lowerValue <= upperValue && lowerValue >= this.minimum && upperValue <= this.maximum && (this.lowerValue != lowerValue || this.upperValue != upperValue)) {
            this.lowerValue = lowerValue;
            this.upperValue = upperValue;
            this.redraw();
        }
    }

    public void setUpperValue(int value) {
        this.setSelection(this.lowerValue, value);
    }
}

