/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.formattedtext;

import java.util.Date;
import java.util.HashMap;
import org.eclipse.nebula.widgets.formattedtext.DateFormatter;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.nebula.widgets.formattedtext.NumberFormatter;
import org.eclipse.nebula.widgets.formattedtext.StringFormatter;
import org.eclipse.swt.SWT;

public abstract class DefaultFormatterFactory {
    private static HashMap<Class<?>, Class<?>> formatters = new HashMap();

    static {
        formatters.put(String.class, StringFormatter.class);
        formatters.put(Date.class, DateFormatter.class);
        formatters.put(Number.class, NumberFormatter.class);
    }

    private DefaultFormatterFactory() {
    }

    public static ITextFormatter createFormatter(Object value) {
        return DefaultFormatterFactory.createFormatter(value.getClass());
    }

    public static ITextFormatter createFormatter(Class<? extends Object> c) {
        ITextFormatter f = null;
        Class<?> fc = formatters.get(c);
        if (fc == null) {
            for (Class<? extends Object> clazz : formatters.keySet()) {
                if (!clazz.isAssignableFrom(c) || fc != null && !fc.isAssignableFrom(clazz)) continue;
                fc = formatters.get(clazz);
            }
        }
        if (fc != null) {
            try {
                f = (ITextFormatter)fc.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public static void register(Class<?> c, Class<?> f) {
        if (c == null) {
            SWT.error((int)4);
        }
        if (!ITextFormatter.class.isAssignableFrom(f)) {
            SWT.error((int)5, null, (String)"Must be an ITextFormatter");
        }
        formatters.put(c, f);
    }
}

