/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery.example;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.animation.ScrollingSmoother;
import org.eclipse.nebula.animation.movement.BounceOut;
import org.eclipse.nebula.animation.movement.ElasticOut;
import org.eclipse.nebula.animation.movement.ExpoOut;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.nebula.animation.movement.LinearInOut;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.examples.ExamplesView;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGridGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.ListItemRenderer;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Spinner;

public class GalleryExampleTab
extends AbstractExampleTab {
    Gallery g = null;
    Listener groupParamSelectionListener = e -> {
        if (this.g != null) {
            this.g.setGroupRenderer((AbstractGalleryGroupRenderer)this.getGroupRenderer());
        }
    };
    Listener itemRendererParamSelectionListener = e -> {
        if (this.g != null) {
            this.g.setItemRenderer(this.getItemRenderer());
        }
    };
    Listener contentParamSelectionListener = e -> this.clearAndPopulateGallery(this.g);
    Image womanImage = null;
    Image bgImage = null;
    Image eclipseImage = null;
    ScrollingSmoother scrollingSmoother;
    Button bMulti = null;
    Button bHScroll = null;
    Button bVScroll = null;
    Button bAnimation = null;
    Button bGroupImage = null;
    Button bGroupDescription = null;
    Button bItemDescription = null;
    Scale scale = null;
    Scale itemWidthScale = null;
    Scale itemHeightScale = null;
    Scale marginsScale = null;
    DefaultGalleryItemRenderer itemRenderer = null;
    AbstractGridGroupRenderer groupRenderer = null;
    private Button bLayoutAutoMargin;
    private Button bLayoutAlwaysExpanded;
    private Combo cAnimationMovement;
    private Spinner sAnimationDuration;
    private Button bLayoutLowQualityOnAction;
    private Button bItemDropShadow;
    private Spinner sItemDropShadowSize;
    private Button bItemLabel;
    private Combo cItemRenderer;
    private Button bDecoratorLeft;
    private Button bDecoratorUp;
    private Button bDecoratorRight;
    private Button bDecoratorDown;
    private Spinner sDecoratorNumber;
    private Combo cGroupRenderer;

    public Control createControl(Composite parent) {
        int style = 0;
        if (this.bMulti.getSelection()) {
            style |= 2;
        }
        if (this.bHScroll.getSelection()) {
            style |= 0x100;
        }
        if (this.bVScroll.getSelection()) {
            style |= 0x200;
        }
        this.g = new Gallery(parent, style);
        this.scrollingSmoother = new ScrollingSmoother((Scrollable)this.g, (IMovement)new ExpoOut());
        this.scrollingSmoother.smoothControl(this.bAnimation.getSelection());
        if (this.groupRenderer != null) {
            this.groupRenderer.dispose();
        }
        this.groupRenderer = this.getGroupRenderer();
        this.g.setGroupRenderer((AbstractGalleryGroupRenderer)this.groupRenderer);
        if (this.itemRenderer != null) {
            this.itemRenderer.dispose();
        }
        this.g.setItemRenderer(this.getItemRenderer());
        if (this.womanImage == null) {
            this.womanImage = ExamplesView.getImage((String)"icons/woman3.png");
        }
        if (this.bgImage == null) {
            this.bgImage = ExamplesView.getImage((String)"icons/background_small.png");
        }
        if (this.eclipseImage == null) {
            this.eclipseImage = ExamplesView.getImage((String)"icons/eclipse.png");
        }
        this.g.setLowQualityOnUserAction(this.bLayoutLowQualityOnAction.getSelection());
        this.clearAndPopulateGallery(this.g);
        return this.g;
    }

    private AbstractGalleryItemRenderer getItemRenderer() {
        DefaultGalleryItemRenderer result = null;
        if (this.cItemRenderer.getSelectionIndex() == 0) {
            DefaultGalleryItemRenderer renderer = new DefaultGalleryItemRenderer();
            renderer.setShowLabels(this.bItemLabel.getSelection());
            renderer.setDropShadowsSize(this.sItemDropShadowSize.getSelection());
            renderer.setDropShadows(this.bItemDropShadow.getSelection());
            result = renderer;
        } else {
            ListItemRenderer renderer = new ListItemRenderer();
            renderer.setShowLabels(this.bItemLabel.getSelection());
            renderer.setDropShadowsSize(this.sItemDropShadowSize.getSelection());
            renderer.setDropShadows(this.bItemDropShadow.getSelection());
            result = renderer;
        }
        return result;
    }

    private AbstractGridGroupRenderer getGroupRenderer() {
        NoGroupRenderer result = null;
        if (this.cGroupRenderer.getSelectionIndex() == 0) {
            DefaultGalleryGroupRenderer groupRenderer = new DefaultGalleryGroupRenderer();
            if (this.bAnimation.getSelection()) {
                groupRenderer.setAnimation(true);
                BounceOut m = null;
                switch (this.cAnimationMovement.getSelectionIndex()) {
                    case 1: {
                        m = new BounceOut();
                        break;
                    }
                    case 2: {
                        m = new ElasticOut();
                        break;
                    }
                    case 3: {
                        m = new LinearInOut();
                        break;
                    }
                    default: {
                        m = new ExpoOut();
                    }
                }
                groupRenderer.setAnimationCloseMovement((IMovement)m);
                groupRenderer.setAnimationOpenMovement((IMovement)m);
                groupRenderer.setAnimationLength(this.sAnimationDuration.getSelection());
            } else {
                groupRenderer.setAnimation(false);
            }
            result = groupRenderer;
        } else {
            NoGroupRenderer groupRenderer;
            result = groupRenderer = new NoGroupRenderer();
        }
        result.setItemWidth(this.itemWidthScale.getSelection());
        result.setItemHeight(this.itemHeightScale.getSelection());
        result.setMinMargin(this.marginsScale.getSelection());
        result.setAutoMargin(this.bLayoutAutoMargin.getSelection());
        result.setAlwaysExpanded(this.bLayoutAlwaysExpanded.getSelection());
        this.scrollingSmoother.smoothControl(this.bAnimation.getSelection());
        return result;
    }

    private void clearAndPopulateGallery(Gallery g) {
        g.removeAll();
        if ((g.getStyle() & 0x10000000) == 0) {
            this.populateGalleryWithGroups(g);
        }
    }

    private void populateGalleryWithGroups(Gallery g) {
        int i = 0;
        while (i < 10) {
            GalleryItem gi1 = new GalleryItem(g, 0);
            gi1.setText("Group " + i + ".jpg");
            if (this.bGroupImage.getSelection()) {
                gi1.setImage(this.womanImage);
            }
            if (this.bGroupDescription.getSelection()) {
                gi1.setText(1, "Group description");
            }
            if (i % 2 == 0) {
                gi1.setExpanded(true);
            }
            int j = 0;
            while (j < 10 * (i + 1)) {
                GalleryItem gi2 = new GalleryItem(gi1, 0);
                if (j % 2 == 0) {
                    gi2.setImage(this.womanImage);
                } else {
                    gi2.setImage(this.bgImage);
                }
                gi2.setText("Eclipse " + i + " " + j + ".jpg");
                if (this.bItemDescription.getSelection()) {
                    gi2.setText(1, "Image description");
                }
                if (this.bDecoratorLeft.getSelection()) {
                    gi2.setData("org.eclipse.nebula.widget.gallery.topLeftOverlay", this.getDecoratorImage(this.eclipseImage, this.sDecoratorNumber.getSelection()));
                }
                if (this.bDecoratorUp.getSelection()) {
                    gi2.setData("org.eclipse.nebula.widget.gallery.topRightOverlay", this.getDecoratorImage(this.eclipseImage, this.sDecoratorNumber.getSelection()));
                }
                if (this.bDecoratorRight.getSelection()) {
                    gi2.setData("org.eclipse.nebula.widget.gallery.bottomRightOverlay", this.getDecoratorImage(this.eclipseImage, this.sDecoratorNumber.getSelection()));
                }
                if (this.bDecoratorDown.getSelection()) {
                    gi2.setData("org.eclipse.nebula.widget.gallery.bottomLeftOverlay", this.getDecoratorImage(this.eclipseImage, this.sDecoratorNumber.getSelection()));
                }
                ++j;
            }
            ++i;
        }
    }

    private Object getDecoratorImage(Image img, int nb) {
        switch (nb) {
            case 0: {
                return null;
            }
            case 1: {
                return img;
            }
        }
        Image[] result = new Image[nb];
        int i = 0;
        while (i < nb) {
            result[i] = img;
            ++i;
        }
        return result;
    }

    public String[] createLinks() {
        String[] links = new String[]{"<a href=\"http://www.eclipse.org/nebula/widgets/gallery/gallery.php\">Gallery Home Page</a>", "<a href=\"http://www.eclipse.org/nebula/snippets.php#Gallery\">Snippets</a>", "<a href=\"https://bugs.eclipse.org/bugs/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=&classification=Technology&product=Nebula&component=Gallery&long_desc_type=allwordssubstr&long_desc=&bug_file_loc_type=allwordssubstr&bug_file_loc=&status_whiteboard_type=allwordssubstr&status_whiteboard=&keywords_type=allwords&keywords=&emailtype1=substring&email1=&emailtype2=substring&email2=&bugidtype=include&bug_id=&votes=&chfieldfrom=&chfieldto=Now&chfieldvalue=&cmdtype=doit&order=Reuse+same+sort+as+last+time&field0-0-0=noop&type0-0-0=noop&value0-0-0=\">Bugs</a>", "<a href=\"http://www.eclipse.org/projects/project-plan.php?projectid=technology.nebula\">Projet plan</a>"};
        return links;
    }

    private Button createButton(Composite parent, int style, String text, boolean selected, boolean createExampleOnChange) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setSelection(selected);
        if (createExampleOnChange) {
            button.addListener(13, e -> this.recreateExample());
        }
        return button;
    }

    private Group createEmptyGroup(Composite parent, String text) {
        Group styleGroup = new Group(parent, 0);
        styleGroup.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        styleGroup.setLayoutData((Object)gd);
        return styleGroup;
    }

    private void createStyleGroup(Composite parent) {
        Group styleGroup = this.createEmptyGroup(parent, "Style");
        styleGroup.setLayout((Layout)new RowLayout());
        this.bMulti = this.createButton((Composite)styleGroup, 32, "SWT.MULTI", false, true);
        this.bVScroll = this.createButton((Composite)styleGroup, 16, "SWT.V_SCROLL", true, true);
        this.bHScroll = this.createButton((Composite)styleGroup, 16, "SWT.H_SCROLL", false, true);
    }

    private void createAnimationGroup(Composite parent) {
        Group animationGroup = this.createEmptyGroup(parent, "Animation");
        animationGroup.setLayout((Layout)new RowLayout());
        this.bAnimation = this.createButton((Composite)animationGroup, 32, "Animations", false, false);
        this.bAnimation.addListener(13, this.groupParamSelectionListener);
        this.cAnimationMovement = new Combo((Composite)animationGroup, 8);
        this.cAnimationMovement.setItems(new String[]{"ExpoOut", "BounceOut", "ElasticOut", "LinearInOut"});
        this.cAnimationMovement.setText("ExpoOut");
        this.cAnimationMovement.addListener(13, this.groupParamSelectionListener);
        this.sAnimationDuration = new Spinner((Composite)animationGroup, 0);
        this.sAnimationDuration.setMinimum(250);
        this.sAnimationDuration.setMaximum(5000);
        this.sAnimationDuration.setIncrement(100);
        this.sAnimationDuration.setSelection(500);
        this.sAnimationDuration.addListener(13, this.groupParamSelectionListener);
    }

    private void createDataGroup(Composite parent) {
        Group dataGroup = this.createEmptyGroup(parent, "Data");
        dataGroup.setLayout((Layout)new RowLayout());
        this.bGroupImage = this.createButton((Composite)dataGroup, 32, "Group image", false, true);
        this.bGroupDescription = this.createButton((Composite)dataGroup, 32, "Group descriptions", false, true);
        this.bItemDescription = this.createButton((Composite)dataGroup, 32, "Item descriptions", false, true);
    }

    private void createLayoutGroup(Composite parent) {
        Group dataGroup = this.createEmptyGroup(parent, "Layout");
        dataGroup.setLayout((Layout)new RowLayout());
        this.bLayoutAutoMargin = this.createButton((Composite)dataGroup, 32, "Auto Margins", false, true);
        this.bLayoutAlwaysExpanded = this.createButton((Composite)dataGroup, 32, "Always expanded", false, true);
        this.bLayoutLowQualityOnAction = this.createButton((Composite)dataGroup, 32, "Low quality on user action", false, true);
    }

    private void createDecoratorsGroup(Composite parent) {
        Group dataGroup = this.createEmptyGroup(parent, "Decorators");
        dataGroup.setLayout((Layout)new RowLayout());
        this.sDecoratorNumber = new Spinner((Composite)dataGroup, 0);
        this.sDecoratorNumber.setMinimum(1);
        this.sDecoratorNumber.setMaximum(5);
        this.sDecoratorNumber.setIncrement(1);
        this.sDecoratorNumber.setSelection(1);
        this.sDecoratorNumber.addListener(13, this.contentParamSelectionListener);
        this.bDecoratorLeft = this.createButton((Composite)dataGroup, 32, "Top Left", false, false);
        this.bDecoratorLeft.addListener(13, this.contentParamSelectionListener);
        this.bDecoratorUp = this.createButton((Composite)dataGroup, 32, "Top Right", false, false);
        this.bDecoratorUp.addListener(13, this.contentParamSelectionListener);
        this.bDecoratorRight = this.createButton((Composite)dataGroup, 32, "Bottom Right", false, false);
        this.bDecoratorRight.addListener(13, this.contentParamSelectionListener);
        this.bDecoratorDown = this.createButton((Composite)dataGroup, 32, "Bottom Left", false, false);
        this.bDecoratorDown.addListener(13, this.contentParamSelectionListener);
    }

    private void createItemParametersGroup(Composite parent) {
        Group dataGroup = this.createEmptyGroup(parent, "Item parameters");
        dataGroup.setLayout((Layout)new RowLayout());
        this.cItemRenderer = new Combo((Composite)dataGroup, 8);
        this.cItemRenderer.setItems(new String[]{"Icon", "List"});
        this.cItemRenderer.setText("Icon");
        this.cItemRenderer.addListener(13, this.itemRendererParamSelectionListener);
        this.bItemDropShadow = this.createButton((Composite)dataGroup, 32, "Drop shadow", false, true);
        this.sItemDropShadowSize = new Spinner((Composite)dataGroup, 0);
        this.sItemDropShadowSize.setMinimum(0);
        this.sItemDropShadowSize.setMaximum(20);
        this.sItemDropShadowSize.setIncrement(1);
        this.sItemDropShadowSize.setSelection(5);
        this.sItemDropShadowSize.addListener(13, this.itemRendererParamSelectionListener);
        this.bItemLabel = this.createButton((Composite)dataGroup, 32, "Display labels", false, true);
    }

    private void createGroupParametersGroup(Composite parent) {
        Group dataGroup = this.createEmptyGroup(parent, "Group parameters");
        GridLayoutFactory.swtDefaults().margins(3, 3).numColumns(3).applyTo((Composite)dataGroup);
        this.cGroupRenderer = new Combo((Composite)dataGroup, 8);
        this.cGroupRenderer.setItems(new String[]{"Show groups", "Hide groups"});
        this.cGroupRenderer.setText("Show groups");
        this.cGroupRenderer.addListener(13, this.groupParamSelectionListener);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.cGroupRenderer.setLayoutData((Object)gridData);
        this.scale = this.createScale((Composite)dataGroup, "Item size", 16, 512, 16, 64);
        this.scale.addListener(13, e -> {
            if (this.g != null) {
                this.groupRenderer.setItemSize(this.scale.getSelection(), this.scale.getSelection());
                this.itemWidthScale.setSelection(this.scale.getSelection());
                this.itemHeightScale.setSelection(this.scale.getSelection());
                this.g.setGroupRenderer((AbstractGalleryGroupRenderer)this.groupRenderer);
            }
        });
        this.itemWidthScale = this.createScale((Composite)dataGroup, "Item width", 16, 512, 16, 64);
        this.itemWidthScale.addListener(13, e -> {
            if (this.g != null) {
                this.groupRenderer.setItemWidth(this.itemWidthScale.getSelection());
                this.g.setGroupRenderer((AbstractGalleryGroupRenderer)this.groupRenderer);
            }
        });
        this.itemHeightScale = this.createScale((Composite)dataGroup, "Item height", 16, 512, 16, 64);
        this.itemHeightScale.addListener(13, e -> {
            if (this.g != null) {
                this.groupRenderer.setItemHeight(this.itemHeightScale.getSelection());
                this.g.setGroupRenderer((AbstractGalleryGroupRenderer)this.groupRenderer);
            }
        });
        this.marginsScale = this.createScale((Composite)dataGroup, "Margins", 0, 128, 16, 10);
        this.marginsScale.addListener(13, e -> {
            if (this.g != null) {
                this.groupRenderer.setMinMargin(this.marginsScale.getSelection());
                this.g.setGroupRenderer((AbstractGalleryGroupRenderer)this.groupRenderer);
            }
        });
    }

    public void createParameters(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(3).applyTo(parent);
        this.createStyleGroup(parent);
        this.createAnimationGroup(parent);
        this.createDataGroup(parent);
        this.createDecoratorsGroup(parent);
        this.createLayoutGroup(parent);
        this.createGroupParametersGroup(parent);
        this.createItemParametersGroup(parent);
        Button b = new Button(parent, 0);
        b.setText("deselectAll");
        b.addListener(13, e -> this.g.deselectAll());
    }

    private Scale createScale(Composite parent, String text, int min, int max, int increment, int value) {
        GridData gridData = new GridData();
        Label l = new Label(parent, 0);
        l.setText(text);
        gridData.horizontalSpan = 1;
        l.setLayoutData((Object)gridData);
        Scale scale = new Scale(parent, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        scale.setLayoutData((Object)gridData);
        scale.setMaximum(max);
        scale.setMinimum(min);
        scale.setPageIncrement(increment);
        scale.setSelection(value);
        return scale;
    }
}

