/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.tree;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.pagination.AbstractPaginationWidget;
import org.eclipse.nebula.widgets.pagination.IPageContentProvider;
import org.eclipse.nebula.widgets.pagination.PageLoaderStrategyHelper;
import org.eclipse.nebula.widgets.pagination.collections.PageResultContentProvider;
import org.eclipse.nebula.widgets.pagination.renderers.ICompositeRendererFactory;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.ResultAndNavigationPageLinksRendererFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class PageableTree
extends AbstractPaginationWidget<Tree> {
    protected static final int DEFAULT_TREE_STYLE = 2818;
    protected TreeViewer viewer;
    private final int treeStyle;

    public PageableTree(Composite parent, int style) {
        this(parent, style, 2818, 10);
    }

    public PageableTree(Composite parent, int style, int treeStyle, int pageSize, IPageContentProvider pageContentProvider) {
        this(parent, style, treeStyle, pageSize, pageContentProvider, PageableTree.getDefaultPageRendererTopFactory(), PageableTree.getDefaultPageRendererBottomFactory(), true);
    }

    public PageableTree(Composite parent, int style, int treeStyle, int pageSize) {
        this(parent, style, treeStyle, pageSize, PageResultContentProvider.getInstance(), PageableTree.getDefaultPageRendererTopFactory(), PageableTree.getDefaultPageRendererBottomFactory(), true);
    }

    public PageableTree(Composite parent, int style, int treeStyle, int pageSize, IPageContentProvider pageContentProvider, ICompositeRendererFactory pageRendererTopFactory, ICompositeRendererFactory pageRendererBottomFactory) {
        this(parent, style, treeStyle, pageSize, pageContentProvider, pageRendererTopFactory, pageRendererBottomFactory, true);
    }

    protected PageableTree(Composite parent, int style, int treeStyle, int pageSize, IPageContentProvider pageContentProvider, ICompositeRendererFactory pageRendererTopFactory, ICompositeRendererFactory pageRendererBottomFactory, boolean createUI) {
        super(parent, style, pageSize, pageContentProvider, pageRendererTopFactory, pageRendererBottomFactory, false);
        this.treeStyle = treeStyle;
        if (createUI) {
            this.createUI(this);
        }
    }

    @Override
    protected Tree createWidget(Composite parent) {
        Tree tree = this.createTree(parent);
        this.viewer = new TreeViewer(tree);
        return tree;
    }

    protected Tree createTree(Composite parent) {
        Tree tree = this.createTree(parent, this.getTreeStyle());
        tree.setLayoutData((Object)new GridData(768));
        return tree;
    }

    protected int getTreeStyle() {
        return this.treeStyle;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    protected Tree createTree(Composite parent, int style) {
        return new Tree(parent, style);
    }

    public static ICompositeRendererFactory getDefaultPageRendererTopFactory() {
        return ResultAndNavigationPageLinksRendererFactory.getFactory();
    }

    public static ICompositeRendererFactory getDefaultPageRendererBottomFactory() {
        return null;
    }

    @Override
    public void refreshPage() {
        PageLoaderStrategyHelper.loadPageAndReplaceItems(this.getController(), (Viewer)this.viewer, this.getPageLoader(), this.getPageContentProvider(), null);
    }
}

