/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.ScalePiece;
import org.eclipse.nebula.paperclips.core.ScalePrint;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class ScaleIterator
implements PrintIterator {
    private final Device device;
    private final PrintIterator target;
    private final Double scale;
    private final Point minimumSize;
    private final Point preferredSize;

    ScaleIterator(ScalePrint print, Device device, GC gc) {
        Util.notNull(print, device, gc);
        this.device = device;
        this.target = print.target.iterator(device, gc);
        this.scale = print.scale;
        Point min = this.target.minimumSize();
        Point pref = this.target.preferredSize();
        if (this.scale == null) {
            this.minimumSize = new Point(1, 1);
            this.preferredSize = pref;
        } else {
            double s = this.scale;
            this.minimumSize = new Point((int)Math.ceil((double)min.x * s), (int)Math.ceil((double)min.y * s));
            this.preferredSize = new Point((int)Math.ceil((double)pref.x * s), (int)Math.ceil((double)pref.y * s));
        }
    }

    private ScaleIterator(ScaleIterator that) {
        this.device = that.device;
        this.target = that.target.copy();
        this.scale = that.scale;
        this.minimumSize = that.minimumSize;
        this.preferredSize = that.preferredSize;
    }

    @Override
    public Point minimumSize() {
        return this.minimumSize;
    }

    @Override
    public Point preferredSize() {
        return this.preferredSize;
    }

    @Override
    public boolean hasNext() {
        return this.target.hasNext();
    }

    @Override
    public PrintPiece next(int width, int height) {
        int scaledHeight;
        Point pref = this.target.preferredSize();
        double scale = this.scale == null ? Math.min(Math.min((double)width / (double)pref.x, (double)height / (double)pref.y), 1.0) : this.scale;
        int scaledWidth = (int)Math.ceil((double)width / scale);
        PrintPiece target = PaperClips.next(this.target, scaledWidth, scaledHeight = (int)Math.ceil((double)height / scale));
        if (target == null) {
            return null;
        }
        return new ScalePiece(this.device, target, scale, width, height);
    }

    @Override
    public PrintIterator copy() {
        return new ScaleIterator(this);
    }
}

