/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.toolbar;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.AnnotationConfigPage;
import org.eclipse.nebula.visualization.xygraph.Messages;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddAnnotationDialog
extends Dialog {
    private AnnotationConfigPage configPage;

    public AddAnnotationDialog(Shell parentShell, IXYGraph xyGraph) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        int num = xyGraph.getPlotArea().getAnnotationList().size();
        String name = NLS.bind((String)Messages.Annotation_DefaultNameFmt, (Object)(num + 1));
        List<Trace> traces = xyGraph.getPlotArea().getTraceList();
        Annotation annotation = traces.size() > 0 ? new Annotation(name, traces.get(0)) : new Annotation(name, xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis());
        this.configPage = new AnnotationConfigPage(xyGraph, annotation);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.Annotation_Add);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parent_composite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent_composite, 0);
        this.configPage.createPage(composite);
        return parent_composite;
    }

    protected void okPressed() {
        this.configPage.applyChanges();
        super.okPressed();
    }

    public Annotation getAnnotation() {
        return this.configPage.getAnnotation();
    }
}

