/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.snippets;

import java.util.Locale;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PropertyTable;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTCheckboxEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTColorEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTComboEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTDateEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTDimensionEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTDirectoryEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTFileEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTFloatEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTFontEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTInsetsEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTIntegerEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTPasswordEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTRectangleEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTSpinnerEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTURLEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class PropertyTableSnippetChangeListener {
    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("PropertyTable snippet");
        shell.setLayout((Layout)new GridLayout());
        TabFolder tabFolder = new TabFolder((Composite)shell, 2048);
        TabItem item1 = new TabItem(tabFolder, 0);
        item1.setText("First");
        item1.setControl((Control)PropertyTableSnippetChangeListener.buildPropertyTable(tabFolder, true, true, true));
        TabItem item2 = new TabItem(tabFolder, 0);
        item2.setText("Second");
        item2.setControl((Control)PropertyTableSnippetChangeListener.buildPropertyTable(tabFolder, false, true, false));
        TabItem item3 = new TabItem(tabFolder, 0);
        item3.setText("Third");
        item3.setControl((Control)PropertyTableSnippetChangeListener.buildPropertyTable(tabFolder, true, false, true));
        TabItem item4 = new TabItem(tabFolder, 0);
        item4.setText("Forth");
        item4.setControl((Control)PropertyTableSnippetChangeListener.buildPropertyTable(tabFolder, true, false, false));
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Button button = new Button((Composite)shell, 8);
        button.setText("Discard");
        button.addListener(13, e -> {
            PropertyTable table = (PropertyTable)tabFolder.getSelection()[0].getControl();
            table.discardChanges();
        });
        button.setLayoutData((Object)new GridData(3, 4, true, false));
        shell.setSize(800, 600);
        shell.open();
        SWTGraphicUtil.centerShell((Shell)shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static PropertyTable buildPropertyTable(TabFolder tabFolder, boolean showButton, boolean showAsCategory, boolean showDescription) {
        PropertyTable table = new PropertyTable((Composite)tabFolder, 0);
        if (showButton) {
            table.showButtons();
        } else {
            table.hideButtons();
        }
        if (showAsCategory) {
            table.viewAsCategories();
        } else {
            table.viewAsFlatList();
        }
        if (showDescription) {
            table.showDescription();
        } else {
            table.hideDescription();
        }
        table.addProperty(new PTProperty("id", "Identifier", "Description for identifier", (Object)"My id")).setCategory("General");
        table.addProperty(new PTProperty("text", "Description", "Description for the description field", (Object)"blahblah...")).setCategory("General");
        table.addProperty(new PTProperty("url", "URL:", "This is a nice <b>URL</b>", (Object)"http://www.google.com").setCategory("General")).setEditor((PTEditor)new PTURLEditor());
        table.addProperty(new PTProperty("password", "Password", "Enter your <i>password</i> and keep it secret...", (Object)"password")).setCategory("General").setEditor((PTEditor)new PTPasswordEditor());
        table.addProperty(new PTProperty("longText", "Long", "Description for the description field, which is soooooo long that you have to scroll to see eveything and this is not user-friendly obviously.\nI keep typing but I've no idea, I just want to make it as long as possible, but\nI've definitively no idea.\nI think this is the last line...\nDid you know that I'm a huge fan of Pink Floyd ?", (Object)"too long...")).setCategory("General");
        table.addProperty(new PTProperty("int", "An integer", "Type any integer", (Object)"123")).setCategory("Number").setEditor((PTEditor)new PTIntegerEditor());
        table.addProperty(new PTProperty("float", "A float", "Type any float", (Object)"123.45")).setCategory("Number").setEditor((PTEditor)new PTFloatEditor());
        table.addProperty(new PTProperty("spinner", "Another integer", "Use a spinner to enter an integer")).setCategory("Number").setEditor((PTEditor)new PTSpinnerEditor(0, 100));
        table.addProperty(new PTProperty("directory", "Directory", "Select a directory")).setCategory("Directory/File").setEditor((PTEditor)new PTDirectoryEditor());
        table.addProperty(new PTProperty("file", "File", "Select a file")).setCategory("Directory/File").setEditor((PTEditor)new PTFileEditor());
        table.addProperty(new PTProperty("comboReadOnly", "Combo (read-only)", "A simple combo with seasons")).setCategory("Combo").setEditor((PTEditor)new PTComboEditor(true, new Object[]{"Spring", "Summer", "Autumn", "Winter"}));
        table.addProperty(new PTProperty("combo", "Combo", "A combo that is not read-only")).setCategory("Combo").setEditor((PTEditor)new PTComboEditor(new Object[]{"Value 1", "Value 2", "Value 3"}));
        table.addProperty(new PTProperty("cb", "Checkbox", "A checkbox")).setCategory("Checkbox").setEditor((PTEditor)new PTCheckboxEditor()).setCategory("Checkbox");
        table.addProperty(new PTProperty("cb2", "Checkbox (disabled)", "A disabled checkbox...")).setEditor((PTEditor)new PTCheckboxEditor()).setCategory("Checkbox").setEnabled(false);
        table.addProperty(new PTProperty("color", "Color", "Pick it !")).setCategory("Misc").setEditor((PTEditor)new PTColorEditor());
        table.addProperty(new PTProperty("font", "Font", "Pick again my friend")).setEditor((PTEditor)new PTFontEditor()).setCategory("Misc");
        table.addProperty(new PTProperty("dimension", "Dimension", "A dimension is composed of a width and a height")).setCategory("Misc").setEditor((PTEditor)new PTDimensionEditor());
        table.addProperty(new PTProperty("rectangle", "Rectangle", "A rectangle is composed of a position (x,y) and a dimension(width,height)")).setCategory("Misc").setEditor((PTEditor)new PTRectangleEditor());
        table.addProperty(new PTProperty("inset", "Inset", "An inset is composed of the following fields:top,left,bottom,right)")).setCategory("Misc").setEditor((PTEditor)new PTInsetsEditor());
        table.addProperty(new PTProperty("date", "Date", "Well, is there something more to say ?")).setCategory("Misc").setEditor((PTEditor)new PTDateEditor());
        Font font = SWTGraphicUtil.buildFontFrom((Control)table, (int)1, (int)10);
        table.addListener(12, e -> SWTGraphicUtil.safeDispose((Resource)font));
        table.addChangeListener(property -> {
            System.out.println("Change for " + property.getDisplayName() + ": new value is " + String.valueOf(property.getValue()));
            property.changeFont(font);
            property.changeForegroundColor(table.getDisplay().getSystemColor(1));
            property.changeBackgroundColor(table.getDisplay().getSystemColor(3));
        });
        return table;
    }
}

