/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.draw2d;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.nebula.widgets.geomap.GeoMapUtil;
import org.eclipse.nebula.widgets.geomap.PointD;
import org.eclipse.nebula.widgets.geomap.TileServer;
import org.eclipse.nebula.widgets.geomap.internal.GeoMapHelper;
import org.eclipse.nebula.widgets.geomap.internal.GeoMapHelperListener;
import org.eclipse.nebula.widgets.geomap.internal.TileRef;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MapFigure
extends ImageFigure
implements GeoMapHelperListener {
    private static int DEFAULT_CACHE_SIZE = 256;
    private GeoMapHelper geoMapHelper;
    private TileServer tileServer;
    private PointD location = null;
    private int zoom = 10;
    private Image cachedImage = null;
    private Display display;

    public void setTileServer(TileServer tileServer) {
        this.tileServer = tileServer;
        this.invalidateImage();
    }

    public void setZoomLevel(int zoom) {
        this.zoom = zoom;
        this.invalidateImage();
    }

    public void setLocation(double longitude, double latitude) {
        this.location = new PointD(longitude, latitude);
        this.invalidateImage();
    }

    private void invalidateImage() {
        Image oldImage = this.getImage();
        if (oldImage != null) {
            this.setImage(null);
        }
        if (this.cachedImage == null) {
            this.cachedImage = oldImage;
        }
    }

    private Display getDisplay() {
        if (this.display == null) {
            this.display = Display.getCurrent();
        }
        return this.display;
    }

    public void paint(Graphics graphics) {
        if (this.getImage() == null) {
            this.updateImage();
        }
        super.paint(graphics);
    }

    private void updateImage() {
        this.updateGeoMapHelper();
        if (this.geoMapHelper != null) {
            Image image;
            Dimension size = this.getSize();
            if (this.cachedImage != null) {
                Rectangle imageSize = this.cachedImage.getBounds();
                if (imageSize.width != size.width || imageSize.height != size.height) {
                    this.cachedImage.dispose();
                    this.cachedImage = null;
                }
            }
            if ((image = this.cachedImage) == null) {
                image = new Image((Device)this.getDisplay(), size.width, size.height);
            }
            this.cachedImage = null;
            GC gc = new GC((Drawable)image);
            this.geoMapHelper.paint(gc, null, new Point(size.width, size.height));
            gc.dispose();
            this.setImage(image);
        }
    }

    private void updateGeoMapHelper() {
        if (this.location != null) {
            Point position = GeoMapUtil.computePosition(this.location, this.zoom);
            if (this.geoMapHelper == null) {
                this.geoMapHelper = new GeoMapHelper(this.getDisplay(), position, this.zoom, DEFAULT_CACHE_SIZE);
                this.geoMapHelper.addGeoMapHelperListener(this);
            }
            if (this.tileServer != null) {
                this.geoMapHelper.setTileServer(this.tileServer);
            }
            this.geoMapHelper.setZoom(this.zoom);
            this.geoMapHelper.setMapPosition(position.x, position.y);
        }
    }

    @Override
    public void tileUpdated(TileRef tileRef) {
        this.invalidateImage();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        display = new Display();
        shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        canvas = new FigureCanvas((Composite)shell);
        mapFigure = new MapFigure();
        mapFigure.setZoomLevel(8);
        mapFigure.setLocation(10.4234, 63.4242);
        canvas.setContents((IFigure)mapFigure);
        shell.setText("MapFigure example");
        shell.setSize(600, 600);
        shell.open();
        ** GOTO lbl17
        {
            display.sleep();
            do {
                if (!display.readAndDispatch()) continue block0;
lbl17:
                // 2 sources

            } while (!shell.isDisposed());
        }
    }
}

