/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.listeners.TimelineScaler;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TimelineComposite
extends Composite {
    private final RootFigure fRootFigure;
    private final LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);

    public TimelineComposite(Composite parent, int style) {
        super(parent, style);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        this.setBackground(ColorConstants.black);
        Canvas canvas = new Canvas((Composite)this, 0x20000000);
        canvas.setBackground(ColorConstants.black);
        LightweightSystem lightWeightSystem = new LightweightSystem(canvas);
        this.fRootFigure = new RootFigure((ResourceManager)this.fResourceManager);
        this.fRootFigure.setFont(parent.getFont());
        lightWeightSystem.setContents((IFigure)this.fRootFigure);
        canvas.addMouseWheelListener((MouseWheelListener)new TimelineScaler(this));
    }

    public RootFigure getRootFigure() {
        return this.fRootFigure;
    }

    public void dispose() {
        this.fRootFigure.getStyleProvider().dispose();
        this.fResourceManager.dispose();
        super.dispose();
    }
}

