/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.detail.track;

import java.util.Map;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.widgets.timeline.figures.IStyledFigure;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.DetailFigure;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;

public class GridLayer
extends FreeformLayer
implements IStyledFigure {
    public GridLayer(ITimelineStyleProvider styleProvider) {
        this.updateStyle(styleProvider);
    }

    protected boolean useLocalCoordinates() {
        return super.useLocalCoordinates();
    }

    protected void paintClientArea(Graphics graphics) {
        this.paintGrid(graphics);
        super.paintClientArea(graphics);
    }

    private void paintGrid(Graphics graphics) {
        ITimelineStyleProvider styleProvider = RootFigure.getRootFigure((IFigure)this).getStyleProvider();
        graphics.setLineStyle(styleProvider.getGridLineStyle());
        Rectangle bounds = this.getBounds();
        Map<Double, Integer> markerPositions = RootFigure.getFigure((IFigure)this, DetailFigure.class).getMarkerPositions();
        for (int position : markerPositions.values()) {
            graphics.drawLine(position + bounds.x(), bounds.y, position + bounds.x(), bounds.y + bounds.height);
        }
    }

    @Override
    public void updateStyle(ITimelineStyleProvider styleProvider) {
        this.setForegroundColor(styleProvider.getGridColor());
        this.setVisible(styleProvider.showGrid());
    }
}

