/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.carousel;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.nebula.widgets.carousel.ImageContainer;
import org.eclipse.nebula.widgets.carousel.ImageSelector;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Carousel
extends Composite {
    int selection = 0;
    final ImageContainer imageContainer;
    final ImageSelector imageSelector;
    private List<Image> images = new ArrayList<Image>();

    public Carousel(Composite parent, int style) {
        super(parent, Carousel.checkStyle(style));
        this.setLayout((Layout)new GridLayout());
        this.imageContainer = new ImageContainer(this, 0);
        this.imageContainer.setLayoutData(new GridData(4, 4, true, true));
        this.imageSelector = new ImageSelector(this, 0);
        this.imageSelector.setLayoutData(new GridData(3, 4, false, false));
        this.initDefaultColors();
        this.addListener(2, e -> {
            if (e.keyCode == 0x1000003) {
                this.imageContainer.movePrevious();
            }
            if (e.keyCode == 0x1000004) {
                this.imageContainer.moveNext();
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 2048;
        int newStyle = style & 0x800;
        return newStyle;
    }

    private void initDefaultColors() {
        this.setArrowColor(this.getDisplay().getSystemColor(2));
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.setCircleBackground(this.getDisplay().getSystemColor(2));
        this.setCircleForeground(SWTGraphicUtil.getColorSafely((int)153, (int)153, (int)153));
        this.setCircleHoverColor(SWTGraphicUtil.getColorSafely((int)102, (int)102, (int)102));
    }

    public void addImage(Image image) {
        this.checkWidget();
        if (image == null) {
            SWT.error((int)4);
        }
        this.images.add(image);
        this.imageContainer.setImage(this.images.get(this.selection));
        this.layout();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13});
    }

    public void removeImage(Image image) {
        this.checkWidget();
        if (image == null) {
            SWT.error((int)4);
        }
        this.images.remove(image);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
    }

    public Color getArrowColor() {
        this.checkWidget();
        return this.imageSelector.arrowColor;
    }

    public Color getCircleBackground() {
        this.checkWidget();
        return this.imageSelector.circleBackground;
    }

    public Color getCircleForeground() {
        this.checkWidget();
        return this.imageSelector.circleForeground;
    }

    public Color getCircleHoverColor() {
        this.checkWidget();
        return this.imageSelector.circleHoverColor;
    }

    public List<Image> getImages() {
        this.checkWidget();
        return this.images;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setArrowColor(Color arrowColor) {
        this.checkWidget();
        this.imageSelector.arrowColor = arrowColor;
        this.imageSelector.redraw();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.imageContainer.setBackground(color);
        this.imageSelector.setBackground(color);
    }

    public void setCircleBackground(Color circleBackground) {
        this.checkWidget();
        this.imageSelector.circleBackground = circleBackground;
        this.imageSelector.redraw();
    }

    public void setCircleForeground(Color circleForeground) {
        this.checkWidget();
        this.imageSelector.circleForeground = circleForeground;
        this.imageSelector.redraw();
    }

    public void setCircleHoverColor(Color circleHoverColor) {
        this.checkWidget();
        this.imageSelector.circleHoverColor = circleHoverColor;
        this.imageSelector.redraw();
    }

    public void setImages(List<Image> images) {
        this.checkWidget();
        if (images == null) {
            SWT.error((int)4);
        }
        this.images = images;
        this.selection = 0;
        this.imageContainer.setImage(images.get(this.selection));
        this.layout();
    }

    public void setSelection(int selected) {
        this.checkWidget();
        if (selected < 0 || selected >= this.images.size()) {
            SWT.error((int)5);
        }
        this.selection = selected;
        this.imageContainer.setImage(this.images.get(this.selection));
        this.redraw();
    }
}

