/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow.widgets;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.preferencewindow.PreferenceWindow;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWChooser;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Text;

public class PWDirectoryChooser
extends PWChooser {
    public PWDirectoryChooser(String label, String propertyKey) {
        super(label, propertyKey);
    }

    @Override
    protected void setButtonAction(Text text, Button button) {
        String originalDirectory = (String)PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        text.setText(originalDirectory);
        button.addListener(13, event -> {
            DirectoryDialog dialog = new DirectoryDialog(text.getShell());
            dialog.setMessage(ResourceManager.getLabel((String)"chooseDirectory"));
            String result = dialog.open();
            if (result != null) {
                text.setText(result);
                PreferenceWindow.getInstance().setValue(this.getPropertyKey(), result);
            }
        });
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), "");
        } else if (!(value instanceof String)) {
            throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a String because it is associated to a directory chooser");
        }
    }
}

