/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.nebulaslider;

import java.util.EventListener;
import java.util.function.IntFunction;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.nebula.widgets.opal.nebulaslider.NebulaSliderGraphicConfiguration;
import org.eclipse.nebula.widgets.opal.nebulaslider.NebularSliderDefaultConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class NebulaSlider
extends Canvas {
    private NebulaSliderGraphicConfiguration renderer = new NebularSliderDefaultConfiguration(this);
    private int minimum = Integer.MIN_VALUE;
    private int maximum = Integer.MAX_VALUE;
    private int value = 0;
    private int xPosition = -1;
    private int mouseDeltaX;
    private boolean moving = false;
    private IntFunction<String> format;
    private int movingValue;

    public NebulaSlider(Composite parent, int style) {
        super(parent, NebulaSlider.checkStyle(style) | 0x20000000);
        this.addPaintListener(e -> this.paintControl(e.gc));
        this.addMouseListeners();
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            return style & 0xFFFFF7FF;
        }
        return 0;
    }

    private void paintControl(GC gc) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        if (this.xPosition < 0) {
            this.xPosition = this.computeXPosition();
        }
        boolean enabled = this.isEnabled();
        this.drawBar(gc, enabled);
        this.drawSelectionPart(gc, enabled);
        this.drawSelector(gc, enabled);
    }

    private void drawBar(GC gc, boolean enabled) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.getColor(this.renderer.getBarBorderColor(), enabled));
        gc.setBackground(this.getColor(this.renderer.getBarInsideColor(), enabled));
        int hMargin = this.renderer.getHorizontalMargin();
        int selectorWidth = this.renderer.getSelectorWidth();
        int barHeight = this.renderer.getBarHeight();
        int x = hMargin + selectorWidth / 2;
        int y = (rect.height - barHeight) / 2;
        int width = rect.width - hMargin * 2 - selectorWidth;
        gc.fillRoundRectangle(x, y, width, barHeight, barHeight, barHeight);
        gc.drawRoundRectangle(x, y, width, barHeight, barHeight, barHeight);
    }

    private void drawSelectionPart(GC gc, boolean enabled) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.getColor(this.renderer.getBarBorderColor(), enabled));
        gc.setBackground(this.getColor(this.renderer.getBarSelectionColor(), enabled));
        int barHeight = this.renderer.getBarHeight();
        int x = this.renderer.getHorizontalMargin() + this.renderer.getSelectorWidth() / 2;
        int y = (rect.height - barHeight) / 2;
        gc.fillRoundRectangle(x, y, this.xPosition, barHeight, barHeight, barHeight);
        gc.drawRoundRectangle(x, y, this.xPosition, barHeight, barHeight, barHeight);
    }

    private int computeXPosition() {
        int originalWidth = this.getClientArea().width - this.renderer.getHorizontalMargin() * 2 - this.renderer.getSelectorWidth();
        float coeff = (float)this.value * 1.0f / (float)(this.maximum - this.minimum);
        int position = (int)(coeff * (float)originalWidth);
        return position;
    }

    private void drawSelector(GC gc, boolean enabled) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.getColor(this.renderer.getSelectorColorBorder(), enabled));
        gc.setBackground(this.getColor(this.renderer.getSelectorColor(), enabled));
        int hMargin = this.renderer.getHorizontalMargin();
        int selectorWidth = this.renderer.getSelectorWidth();
        int selectorHeight = this.renderer.getSelectorHeight();
        int y = (rect.height - selectorHeight) / 2;
        gc.fillRoundRectangle(hMargin + this.xPosition, y, selectorWidth, selectorHeight, selectorHeight, selectorHeight);
        gc.drawRoundRectangle(hMargin + this.xPosition, y, selectorWidth, selectorHeight, selectorHeight, selectorHeight);
        gc.setForeground(this.getColor(this.renderer.getArrowColor(), enabled));
        gc.setLineWidth(this.renderer.getArrowLineWidth());
        int baseY = y + selectorHeight / 2;
        gc.drawLine(hMargin + this.xPosition + 10, baseY, hMargin + this.xPosition + 17, baseY - 7);
        gc.drawLine(hMargin + this.xPosition + 10, baseY, hMargin + this.xPosition + 17, baseY + 7);
        gc.drawLine(hMargin + this.xPosition + selectorWidth - 10, baseY, hMargin + this.xPosition + selectorWidth - 17, baseY - 7);
        gc.drawLine(hMargin + this.xPosition + selectorWidth - 10, baseY, hMargin + this.xPosition + selectorWidth - 17, baseY + 7);
        gc.setForeground(this.getColor(this.renderer.getSelectorTextColor(), enabled));
        gc.setFont(this.renderer.getTextFont());
        String valueAsString = this.stringValueOf(this.value);
        Point textSize = gc.textExtent(valueAsString);
        int xText = hMargin + this.xPosition + selectorWidth / 2;
        int yText = y + selectorHeight / 2;
        gc.drawText(valueAsString, xText - textSize.x / 2, yText - textSize.y / 2, true);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.xPosition = -1;
        super.setBounds(x, y, width, height);
    }

    public void setEnabled(boolean enabled) {
        if (!enabled && this.moving) {
            this.moving = false;
        }
        super.setEnabled(enabled);
    }

    private Color getColor(Color color, boolean enabled) {
        if (enabled) {
            return color;
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        if (red == green && green == blue) {
            return color;
        }
        int g = (int)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue);
        return new Color(g, g, g);
    }

    private String stringValueOf(int value) {
        if (this.format != null) {
            return this.format.apply(value);
        }
        return String.valueOf(value);
    }

    public void setLabelFormatProvider(IntFunction<String> format) {
        this.checkWidget();
        this.format = format;
    }

    public IntFunction<String> getLabelFormatProvider() {
        this.checkWidget();
        return this.format;
    }

    private void addMouseListeners() {
        this.addListener(3, e -> {
            if (this.isEnabled()) {
                int selectorWidth = this.renderer.getSelectorWidth();
                int selectorHeight = this.renderer.getSelectorHeight();
                int y = (this.getClientArea().height - selectorHeight) / 2;
                Rectangle rect = new Rectangle(this.xPosition + this.renderer.getHorizontalMargin(), y, selectorWidth, selectorHeight);
                if (!rect.contains(e.x, e.y)) {
                    return;
                }
                this.moving = true;
                this.movingValue = this.value;
                this.mouseDeltaX = this.xPosition - e.x;
            }
        });
        this.addListener(8, e -> {
            this.moving = false;
            this.mouseDeltaX = 0;
        });
        this.addListener(4, e -> {
            if (!this.moving) {
                return;
            }
            this.moving = false;
            this.mouseDeltaX = 0;
            if (this.movingValue != this.value) {
                SelectionListenerUtil.fireDefaultSelectionListeners((Control)this, (Event)e);
            }
            this.redraw();
        });
        this.addListener(5, e -> {
            float ratio;
            int value;
            int originalWidth;
            if (!this.moving) {
                return;
            }
            this.xPosition = e.x + this.mouseDeltaX;
            if (this.xPosition < 0) {
                this.xPosition = 0;
            }
            if (this.xPosition > (originalWidth = this.getClientArea().width - this.renderer.getHorizontalMargin() * 2 - this.renderer.getSelectorWidth())) {
                this.xPosition = originalWidth;
            }
            if (this.value != (value = (int)Math.floor((ratio = (float)this.xPosition / (float)originalWidth) * (float)(this.maximum - this.minimum)))) {
                this.value = value;
                SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e);
            }
            this.redraw();
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13});
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(Math.max(300, wHint), this.renderer.getSelectorHeight() + 2);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.checkWidget();
        if (minimum > this.maximum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is greater than the maximum value (%d)", minimum, this.maximum)));
        }
        this.minimum = minimum;
        this.redraw();
        this.update();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        if (maximum < this.minimum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is lower than the minimum value (%d)", maximum, this.minimum)));
        }
        this.maximum = maximum;
        this.redraw();
        this.update();
    }

    public int getValue() {
        this.checkWidget();
        return this.value;
    }

    public void setValue(int value) {
        this.checkWidget();
        if (value < this.minimum || value > this.maximum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is not int the range [%d - %d]", value, this.minimum, this.maximum)));
        }
        this.value = value;
        this.xPosition = -1;
        this.redraw();
        this.update();
    }

    public NebulaSliderGraphicConfiguration getRenderer() {
        this.checkWidget();
        return this.renderer;
    }

    public void setRenderer(NebulaSliderGraphicConfiguration renderer) {
        this.checkWidget();
        this.renderer = renderer;
        this.redraw();
    }
}

