/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.example;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.widgets.timeline.ILane;
import org.eclipse.nebula.widgets.timeline.ITimeline;
import org.eclipse.nebula.widgets.timeline.ITrack;
import org.eclipse.nebula.widgets.timeline.TimelineDataBinding;
import org.eclipse.nebula.widgets.timeline.jface.TimelineViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TimelineExampleTab
extends AbstractExampleTab {
    private static final int DISPLAY_UPDATE_DELAY = 300;

    public String[] createLinks() {
        return new String[0];
    }

    public void createParameters(Composite parent) {
    }

    public Control createControl(Composite parent) {
        TimelineViewer timelineViewer = new TimelineViewer(parent, 0);
        ITimeline model = (ITimeline)timelineViewer.getInput();
        new TimelineDataBinding(timelineViewer, model, 300L);
        this.createRandomContent(model);
        return timelineViewer.getControl();
    }

    private void createRandomContent(ITimeline model) {
        ITrack track4 = model.createTrack("High Level");
        ITrack track3 = model.createTrack("Low Level");
        ILane requests = track4.createLane();
        ILane responses = track4.createLane();
        ILane one = track3.createLane();
        ILane two = track3.createLane();
        ILane three = track3.createLane();
        ILane four = track3.createLane();
        List<ILane> lanes = Arrays.asList(requests, responses, one, two, three, four);
        SecureRandom random = new SecureRandom();
        int lastPosition = 0;
        int item = 0;
        while (item < 40) {
            int laneIndex = random.nextInt(lanes.size());
            ILane lane = lanes.get(laneIndex);
            int offset = random.nextInt(20);
            int width = random.nextInt(150);
            lane.createEvent("Item " + item, lastPosition + offset + " - " + (lastPosition + offset + width), (long)(lastPosition + offset), (long)width, TimeUnit.NANOSECONDS);
            lastPosition += offset + width;
            ++item;
        }
        model.createCursor(122L, TimeUnit.NANOSECONDS);
    }
}

