/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.led;

import org.eclipse.nebula.widgets.led.BaseLED;
import org.eclipse.nebula.widgets.led.LEDCharacter;
import org.eclipse.nebula.widgets.led.LEDLine;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class LED
extends BaseLED {
    private static final int DEFAULT_WIDTH = 60;
    private LEDLine[] lines;
    private boolean showDot;
    private boolean hasDot;

    public LED(Composite parent, int style) {
        super(parent, LED.checkStyle(style) | 0x20000000);
        this.initLinesConfiguration();
        this.hasDot = (this.getStyle() & 1) == 1;
    }

    private static int checkStyle(int style) {
        int mask = 2049;
        int newStyle = style & 0x801;
        return newStyle |= 0x20000000;
    }

    private void initLinesConfiguration() {
        LEDLine[] lEDLineArray = new LEDLine[7];
        int[] nArray = new int[14];
        nArray[1] = 5;
        nArray[2] = 10;
        nArray[4] = 50;
        nArray[6] = 60;
        nArray[7] = 5;
        nArray[8] = 50;
        nArray[9] = 10;
        nArray[10] = 10;
        nArray[11] = 10;
        nArray[13] = 5;
        lEDLineArray[0] = new LEDLine(nArray);
        lEDLineArray[1] = new LEDLine(new int[]{60, 7, 60, 48, 50, 43, 50, 12, 60, 7});
        lEDLineArray[2] = new LEDLine(new int[]{60, 52, 60, 93, 50, 88, 50, 57, 60, 52});
        int[] nArray2 = new int[14];
        nArray2[1] = 95;
        nArray2[2] = 10;
        nArray2[3] = 90;
        nArray2[4] = 50;
        nArray2[5] = 90;
        nArray2[6] = 60;
        nArray2[7] = 95;
        nArray2[8] = 50;
        nArray2[9] = 100;
        nArray2[10] = 10;
        nArray2[11] = 100;
        nArray2[13] = 95;
        lEDLineArray[3] = new LEDLine(nArray2);
        int[] nArray3 = new int[10];
        nArray3[1] = 52;
        nArray3[2] = 10;
        nArray3[3] = 57;
        nArray3[4] = 10;
        nArray3[5] = 88;
        nArray3[7] = 93;
        nArray3[9] = 52;
        lEDLineArray[4] = new LEDLine(nArray3);
        int[] nArray4 = new int[10];
        nArray4[1] = 7;
        nArray4[2] = 10;
        nArray4[3] = 12;
        nArray4[4] = 10;
        nArray4[5] = 43;
        nArray4[7] = 48;
        nArray4[9] = 7;
        lEDLineArray[5] = new LEDLine(nArray4);
        int[] nArray5 = new int[14];
        nArray5[1] = 50;
        nArray5[2] = 10;
        nArray5[3] = 45;
        nArray5[4] = 50;
        nArray5[5] = 45;
        nArray5[6] = 60;
        nArray5[7] = 50;
        nArray5[8] = 50;
        nArray5[9] = 55;
        nArray5[10] = 10;
        nArray5[11] = 55;
        nArray5[13] = 50;
        lEDLineArray[6] = new LEDLine(nArray5);
        this.lines = lEDLineArray;
    }

    @Override
    protected void paintInternal() {
        int i = 0;
        while (i < 7) {
            this.lines[i].paint(this);
            ++i;
        }
        if (this.hasDot && this.showDot) {
            this.gc.setBackground(this.selectedColor);
            Rectangle clientArea = this.getClientArea();
            this.gc.fillOval((int)((float)clientArea.width - 15.0f) + 1, clientArea.height - 10, 10, 10);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int x;
        int n = x = wHint == -1 ? 60 : wHint;
        if (this.hasDot) {
            x += 15;
        }
        int y = hHint == -1 ? 100 : hHint;
        return new Point(x, y);
    }

    public boolean isShowDot() {
        this.checkWidget();
        return this.showDot;
    }

    public void setShowDot(boolean showDot) {
        this.checkWidget();
        this.showDot = showDot;
        this.redraw();
    }

    public void setCharacter(LEDCharacter character) {
        this.checkWidget();
        if (character == null) {
            SWT.error((int)4);
        }
        int i = 0;
        while (i < 7) {
            this.lines[i].setSwitechOnFlag(character.isSwitchedOn(i));
            ++i;
        }
        this.redraw();
    }
}

