/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pshelf.css.internal;

import org.eclipse.e4.ui.css.core.css2.CSS2FontPropertiesHelpers;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontPropertiesImpl;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.nebula.widgets.pshelf.css.CSSShelfRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class CSSEngineHelper {
    Control control;
    IStylingEngine styleEngine;
    CSSStyleDeclaration style;
    CSSShelfRenderer renderer;
    CSSEngine cssEngine;

    public CSSEngineHelper(IStylingEngine styleEngine, Control control, CSSShelfRenderer renderer) {
        this.styleEngine = styleEngine;
        this.cssEngine = WidgetElement.getEngine((Widget)control);
        this.control = control;
        this.renderer = renderer;
        this.initialize();
    }

    private void initialize() {
        if (this.styleEngine != null) {
            this.style = this.styleEngine.getStyle((Object)this.control);
        }
    }

    public Color getBaseColorSelected() {
        if (this.style == null) {
            return this.control.getDisplay().getSystemColor(32);
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-basecolor-selected"), this.control.getDisplay().getSystemColor(32));
    }

    public Color getBaseColorUnselected() {
        if (this.style == null) {
            return this.control.getDisplay().getSystemColor(26);
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-basecolor-unselected"), this.control.getDisplay().getSystemColor(26));
    }

    public Color getBaseColorHover() {
        if (this.style == null) {
            return this.control.getDisplay().getSystemColor(31);
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-basecolor-hover"), this.control.getDisplay().getSystemColor(31));
    }

    public Color getSelectedColorStart() {
        if (this.style == null) {
            return null;
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-selectedcolor-start"), null);
    }

    public Color getSelectedColorEnd() {
        if (this.style == null) {
            return null;
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-selectedcolor-end"), null);
    }

    public Color getUnselectedColorStart() {
        if (this.style == null) {
            return null;
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-unselectedcolor-start"), null);
    }

    public Color getUnselectedColorEnd() {
        if (this.style == null) {
            return null;
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-unselectedcolor-end"), null);
    }

    public Color getHoverColorStart() {
        if (this.style == null) {
            return null;
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-hovercolor-start"), null);
    }

    public Color getHoverColorEnd() {
        if (this.style == null) {
            return null;
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-hovercolor-end"), null);
    }

    public Color getForegroundColor() {
        if (this.style == null) {
            return null;
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-foregroundcolor"), null);
    }

    public Color getSelectedForegroundColor() {
        if (this.style == null) {
            return null;
        }
        return this.getColor(this.style.getPropertyCSSValue("pshelf-selected-foregroundcolor"), null);
    }

    public Font getSelectedFont() {
        if (this.style == null) {
            return null;
        }
        return this.getFont("pshelf-selected-");
    }

    public Font getUnselectedFont() {
        if (this.style == null) {
            return null;
        }
        return this.getFont("pshelf-unselected-");
    }

    private Color getColor(CSSValue value, Color defaultValue) {
        if (value instanceof RGBColor) {
            RGBColor rgbValue = (RGBColor)((Object)value);
            RGB rgb = new RGB(Integer.parseInt(rgbValue.getRed().getCssText()), Integer.parseInt(rgbValue.getGreen().getCssText()), Integer.parseInt(rgbValue.getBlue().getCssText()));
            return new Color((Device)this.control.getDisplay(), rgb);
        }
        if (value != null) {
            try {
                Color c = (Color)this.cssEngine.convert(value, Color.class, (Object)this.control.getDisplay());
                return new Color((Device)this.control.getDisplay(), c.getRed(), c.getGreen(), c.getBlue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private Font getFont(String prefix) {
        CSS2FontPropertiesImpl properties = new CSS2FontPropertiesImpl();
        boolean modified = false;
        CSSValue v = this.style.getPropertyCSSValue(prefix + "font-family");
        if (v != null) {
            modified = true;
            CSS2FontPropertiesHelpers.updateCSSPropertyFont((CSS2FontProperties)properties, (String)"font-family", (CSSValue)v);
        }
        if ((v = this.style.getPropertyCSSValue(prefix + "font-size")) != null) {
            modified = true;
            CSS2FontPropertiesHelpers.updateCSSPropertyFont((CSS2FontProperties)properties, (String)"font-size", (CSSValue)v);
        }
        if ((v = this.style.getPropertyCSSValue(prefix + "font-style")) != null) {
            modified = true;
            CSS2FontPropertiesHelpers.updateCSSPropertyFont((CSS2FontProperties)properties, (String)"font-style", (CSSValue)v);
        }
        if ((v = this.style.getPropertyCSSValue(prefix + "font")) != null) {
            modified = true;
            CSS2FontPropertiesHelpers.updateCSSPropertyFont((CSS2FontProperties)properties, (String)"font", (CSSValue)v);
        }
        if (modified) {
            return CSSSWTFontHelper.getFont((CSS2FontProperties)properties, (Control)this.control);
        }
        return null;
    }
}

