/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.launcher.snippets;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.nebula.widgets.opal.launcher.Launcher;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LauncherSnippetAdvanced {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(1, false));
        Label title = new Label((Composite)shell, 0);
        title.setText("Launcher");
        title.setLayoutData((Object)new GridData(4, 4, true, false));
        Launcher l = new Launcher((Composite)shell, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, true));
        l.setItemBackgroundColor(display.getSystemColor(3));
        l.setSelectedItemBackgroundColor(display.getSystemColor(7));
        l.setNumberOfColumns(4);
        l.setSingleClickSelection(true);
        Font defaultFont = new Font((Device)display, "Consolas", 18, 1);
        l.setFont(defaultFont);
        SWTGraphicUtil.addDisposer((Widget)shell, (Resource[])new Resource[]{defaultFont});
        l.addItem("Address Book", LauncherSnippetAdvanced.createImage(shell, "x-office-address-book.png"));
        l.addItem("Calendar", LauncherSnippetAdvanced.createImage(shell, "x-office-calendar.png"));
        l.addItem("Presentation", LauncherSnippetAdvanced.createImage(shell, "x-office-presentation.png"));
        l.addItem("Spreadsheet", LauncherSnippetAdvanced.createImage(shell, "x-office-spreadsheet.png"));
        l.addItem("Ease", LauncherSnippetAdvanced.createImage(shell, "ease128.png"));
        l.addItem("eGit", LauncherSnippetAdvanced.createImage(shell, "egit.png"));
        l.addItem("EMF", LauncherSnippetAdvanced.createImage(shell, "emfstoreSmall.png"));
        l.addItem("Glassfish", LauncherSnippetAdvanced.createImage(shell, "glassfish.png"));
        l.addItem("IOT", LauncherSnippetAdvanced.createImage(shell, "iot_logo_large_transparent.png"));
        l.addItem("Papyrus", LauncherSnippetAdvanced.createImage(shell, "Papyrus.gif"));
        l.addItem("SWTBot", LauncherSnippetAdvanced.createImage(shell, "swtbot128.png"));
        l.addListener(13, e -> Dialog.inform((String)"Selection", (String)("You have selected item #" + l.getSelection())));
        Label under = new Label((Composite)shell, 0);
        under.setText("Double-click an icon to launch the program");
        under.setLayoutData((Object)new GridData(4, 4, true, false));
        shell.layout();
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static Image createImage(Shell shell, String input) {
        Image img = new Image((Device)shell.getDisplay(), LauncherSnippetAdvanced.class.getResourceAsStream("icons/" + input));
        shell.addListener(12, e -> SWTGraphicUtil.safeDispose((Resource)img));
        return img;
    }
}

