/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.nebula.widgets.timeline.ICursor;
import org.eclipse.nebula.widgets.timeline.ITimed;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.ITimelineFactory;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.figures.IStyledFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.DetailFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorLayer;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.TrackFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.TracksLayer;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.EventFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.LaneFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewCursorFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewCursorLayer;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewEventFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewEventLayer;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewSelectionLayer;
import org.eclipse.nebula.widgets.timeline.jface.DefaultTimelineStyleProvider;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;
import org.eclipse.nebula.widgets.timeline.listeners.ICursorListener;
import org.eclipse.swt.graphics.Color;

public class RootFigure
extends Figure
implements IStyledFigure {
    private final TimeBaseConverter fTimeViewDetails;
    private ITimelineStyleProvider fStyleProvider;
    private EventFigure fSelection;
    private final Map<IFigure, IFigure> fDetailToOverviewMap = new HashMap<IFigure, IFigure>();
    private final ListenerList<ICursorListener> fCursorListener = new ListenerList();
    private final ResourceManager fResourceManager;
    private final DetailFigure fDetailFigure;
    private final OverviewFigure fOverviewFigure;

    public static RootFigure getRootFigure(IFigure figure) {
        if (figure instanceof RootFigure || figure == null) {
            return (RootFigure)figure;
        }
        return RootFigure.getRootFigure(figure.getParent());
    }

    public static TimeBaseConverter getTimeViewDetails(IFigure parent) {
        return RootFigure.getRootFigure(parent).getTimeViewDetails();
    }

    public static <T> T getFigure(IFigure figure, Class<T> clazz) {
        RootFigure rootFigure = RootFigure.getRootFigure(figure);
        return RootFigure.findFigure((IFigure)rootFigure, clazz);
    }

    private static <T> T findFigure(IFigure figure, Class<T> clazz) {
        if (clazz.isAssignableFrom(figure.getClass())) {
            return (T)figure;
        }
        if (figure instanceof TracksLayer) {
            return null;
        }
        if (figure instanceof OverviewEventLayer) {
            return null;
        }
        if (figure instanceof OverviewCursorLayer) {
            return null;
        }
        for (Object child : figure.getChildren()) {
            T candidate = RootFigure.findFigure((IFigure)child, clazz);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private static List<LaneFigure> getLanes(IFigure figure) {
        ArrayList<LaneFigure> lanes = new ArrayList<LaneFigure>();
        TracksLayer tracksLayer = RootFigure.getFigure(figure, TracksLayer.class);
        for (Object trackFigure : tracksLayer.getChildren()) {
            lanes.addAll(((IFigure)trackFigure).getChildren());
        }
        return lanes;
    }

    public static int getLaneCount(IFigure figure) {
        return RootFigure.getLanes(figure).size();
    }

    public static int getLaneIndex(EventFigure figure) {
        List<LaneFigure> lanes = RootFigure.getLanes((IFigure)figure);
        return lanes.indexOf(figure.getParent());
    }

    public RootFigure(ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
        this.setStyleProvider(null);
        this.fTimeViewDetails = new TimeBaseConverter(this);
        BorderLayout layout = new BorderLayout();
        layout.setVerticalSpacing(10);
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
        this.updateStyle(this.fStyleProvider);
        this.fDetailFigure = new DetailFigure(this.getStyleProvider());
        this.add((IFigure)this.fDetailFigure, BorderLayout.CENTER);
        this.fOverviewFigure = new OverviewFigure(this.getStyleProvider());
        this.add((IFigure)this.fOverviewFigure, BorderLayout.BOTTOM);
    }

    public void setStyleProvider(ITimelineStyleProvider styleProvider) {
        this.fStyleProvider = styleProvider != null ? styleProvider : new DefaultTimelineStyleProvider(this.fResourceManager);
        this.fireStyleChanged();
    }

    public ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    public void addCursorListener(ICursorListener listener) {
        this.fCursorListener.add((Object)listener);
    }

    public void removeCursorListener(ICursorListener listener) {
        this.fCursorListener.remove((Object)listener);
    }

    private void fireStyleChanged() {
        HashSet<RootFigure> children = new HashSet<RootFigure>();
        children.add(this);
        while (!children.isEmpty()) {
            Object child = children.iterator().next();
            children.remove(child);
            children.addAll(((IFigure)child).getChildren());
            if (!(child instanceof IStyledFigure)) continue;
            ((IStyledFigure)child).updateStyle(this.getStyleProvider());
        }
    }

    public ITimelineStyleProvider getStyleProvider() {
        return this.fStyleProvider;
    }

    public void clear() {
        RootFigure.getFigure((IFigure)this, TracksLayer.class).removeAll();
        RootFigure.getFigure((IFigure)this, OverviewEventLayer.class).removeAll();
        RootFigure.getFigure((IFigure)this, CursorLayer.class).removeAll();
        RootFigure.getFigure((IFigure)this, OverviewCursorLayer.class).removeAll();
    }

    public TimeBaseConverter getTimeViewDetails() {
        return this.fTimeViewDetails;
    }

    public void fireTimebaseChanged() {
        for (LaneFigure lane : RootFigure.getLanes((IFigure)this)) {
            lane.revalidate();
        }
        RootFigure.getFigure((IFigure)this, CursorLayer.class).revalidate();
        this.getUpdateManager().addDirtyRegion((IFigure)this.fDetailFigure, this.fDetailFigure.getBounds());
        RootFigure.getFigure((IFigure)this, OverviewSelectionLayer.class).revalidate();
    }

    public void zoomIn(int zoomCenterX) {
        this.zoom(this.getStyleProvider().getZoomFactor(), zoomCenterX);
    }

    public void zoomOut(int zoomCenterX) {
        this.zoom(1.0 / this.getStyleProvider().getZoomFactor(), zoomCenterX);
    }

    public void zoom(double factor, int zoomCenterX) {
        this.getTimeViewDetails().zoom(factor, zoomCenterX);
    }

    @Override
    public void updateStyle(ITimelineStyleProvider styleProvider) {
        this.setBackgroundColor(styleProvider.getBackgroundColor());
    }

    public TrackFigure createTrackFigure(String title) {
        TrackFigure trackFigure = new TrackFigure(title, this.getStyleProvider());
        RootFigure.getFigure((IFigure)this, TracksLayer.class).add((IFigure)trackFigure);
        return trackFigure;
    }

    public LaneFigure createLaneFigure(TrackFigure track) {
        LaneFigure laneFigure = new LaneFigure(this.getStyleProvider());
        track.add((IFigure)laneFigure);
        return laneFigure;
    }

    public ICursor createCursor(long eventTime) {
        ICursor cursor = ITimelineFactory.eINSTANCE.createCursor();
        cursor.setTimestamp(eventTime);
        CursorFigure cursorFigure = this.createCursorFigure(cursor);
        for (ICursorListener listener : this.fCursorListener) {
            try {
                listener.notifyCursorCreated(cursor, cursorFigure);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cursor;
    }

    public void deleteCursor(ICursor cursor) {
        IFigure cursorLayer = (IFigure)RootFigure.getFigure((IFigure)this, CursorLayer.class);
        LayoutManager layoutManager = cursorLayer.getLayoutManager();
        for (Object child : cursorLayer.getChildren()) {
            if (!cursor.equals(layoutManager.getConstraint((IFigure)child))) continue;
            this.deleteCursorFigure((CursorFigure)child);
            for (ICursorListener listener : this.fCursorListener) {
                try {
                    listener.notifyCursorDeleted(cursor);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void setSelection(EventFigure eventFigure) {
        if (this.fSelection != null) {
            this.getStyleProvider().unselectEvent(this.fSelection);
        }
        this.fSelection = eventFigure;
        if (this.fSelection != null) {
            this.getStyleProvider().selectEvent(this.fSelection);
        }
    }

    public EventFigure getSelection() {
        return this.fSelection;
    }

    public EventFigure createEventFigure(LaneFigure parent, ITimelineEvent event) {
        EventFigure eventFigure = new EventFigure(event);
        parent.add((IFigure)eventFigure, event);
        Color eventColor = parent.getForegroundColor();
        if (event.getColorCode() != null) {
            eventColor = this.getStyleProvider().getColor(event.getRgb());
        }
        eventFigure.setEventColor(eventColor);
        RootFigure.getTimeViewDetails((IFigure)parent).addEvent(event);
        OverviewEventLayer overview = RootFigure.getFigure((IFigure)parent, OverviewEventLayer.class);
        OverviewEventFigure overviewEventFigure = overview.addEvent(eventFigure);
        this.fDetailToOverviewMap.put((IFigure)eventFigure, (IFigure)overviewEventFigure);
        return eventFigure;
    }

    public void deleteEventFigure(EventFigure eventFigure) {
        this.removeFigure((IFigure)eventFigure);
        IFigure overvievFigure = this.fDetailToOverviewMap.remove(eventFigure);
        if (overvievFigure != null) {
            this.removeFigure(overvievFigure);
        }
        Timing eventTiming = eventFigure.getEvent().getTiming();
        Timing eventArea = this.getTimeViewDetails().getEventArea();
        if (eventTiming.left() <= eventArea.left() || eventTiming.right() >= eventArea.right()) {
            this.getTimeViewDetails().resetEventArea();
            for (LaneFigure lane : RootFigure.getLanes((IFigure)this)) {
                List children = lane.getChildren();
                if (children.size() >= 2) {
                    this.getTimeViewDetails().addEvent(((EventFigure)children.get(children.size() - 1)).getEvent());
                }
                if (children.size() < 1) continue;
                this.getTimeViewDetails().addEvent(((EventFigure)children.get(0)).getEvent());
            }
            CursorLayer cursorLayer = RootFigure.getFigure((IFigure)this, CursorLayer.class);
            for (Object cursorFigure : cursorLayer.getChildren()) {
                Object cursor = cursorLayer.getLayoutManager().getConstraint((IFigure)cursorFigure);
                if (!(cursor instanceof ITimed)) continue;
                this.getTimeViewDetails().addEvent((ITimed)cursor);
            }
        }
    }

    private void removeFigure(IFigure figure) {
        IFigure parent = figure.getParent();
        parent.remove(figure);
        parent.revalidate();
    }

    public CursorFigure createCursorFigure(ICursor cursor) {
        CursorFigure cursorFigure = new CursorFigure(this.getStyleProvider());
        CursorLayer cursorLayer = RootFigure.getFigure((IFigure)this, CursorLayer.class);
        cursorLayer.add((IFigure)cursorFigure, cursor);
        RootFigure.getTimeViewDetails((IFigure)this).addEvent(cursor);
        OverviewCursorFigure overviewCursorFigure = new OverviewCursorFigure(this.getStyleProvider());
        OverviewCursorLayer overviewCursorLayer = RootFigure.getFigure((IFigure)this, OverviewCursorLayer.class);
        overviewCursorLayer.add((IFigure)overviewCursorFigure, cursor);
        this.fDetailToOverviewMap.put((IFigure)cursorFigure, (IFigure)overviewCursorFigure);
        return cursorFigure;
    }

    public void deleteCursorFigure(CursorFigure cursorFigure) {
        this.removeFigure((IFigure)cursorFigure);
        IFigure overviewCursorFigure = this.fDetailToOverviewMap.remove(cursorFigure);
        if (overviewCursorFigure != null) {
            this.removeFigure(overviewCursorFigure);
        }
    }

    public void updateCursorFigure(IFigure figure, ICursor cursor) {
        this.updateFigureConstraint(figure, cursor);
    }

    public void updateEventFigure(IFigure figure, ITimelineEvent event) {
        this.updateFigureConstraint(figure, event);
    }

    private void updateFigureConstraint(IFigure figure, Object constraint) {
        figure.getParent().getLayoutManager().setConstraint(figure, constraint);
        figure.revalidate();
    }

    public void updateTrackFigure(IFigure figure, String title) {
        if (figure instanceof TrackFigure) {
            ((TrackFigure)figure).setTitle(title);
            ((TrackFigure)figure).updateStyle(this.getStyleProvider());
        }
    }
}

