/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui;

import java.io.File;
import java.util.HashMap;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public final class ImageURIRegistry {
    public static final ImageURIRegistry INSTANCE = new ImageURIRegistry();
    private static final String IMAGE_DIR = "emf-common-ui-images";
    private HashMap<ImageDescriptor, URI> descriptorToURIMap = new HashMap();
    private final File imageDirectory = this.getTempDir();
    private int imageCount;

    private ImageURIRegistry() {
    }

    public URI getImageURI(Image image) {
        return this.getImageURI(ImageDescriptor.createFromImage((Image)image));
    }

    public synchronized URI getImageURI(ImageDescriptor descriptor) {
        if (this.imageDirectory == null) {
            return null;
        }
        URI uri = this.descriptorToURIMap.get(descriptor);
        if (uri != null) {
            return uri;
        }
        File imageFile = this.getNewFile();
        ImageData imageData = descriptor.getImageData();
        if (imageData == null) {
            return null;
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        try {
            loader.save(imageFile.getAbsolutePath(), 5);
            uri = URI.createURI((String)imageFile.toURI().toString());
            this.descriptorToURIMap.put(descriptor, uri);
            return uri;
        }
        catch (RuntimeException exception) {
            return null;
        }
    }

    private File getTempDir() {
        File imageDirectory;
        block5: {
            try {
                imageDirectory = CommonUIPlugin.getPlugin().getStateLocation().append(IMAGE_DIR).toFile();
                if (imageDirectory.exists()) {
                    this.delete(imageDirectory);
                }
                if (!imageDirectory.exists()) {
                    imageDirectory.mkdir();
                }
                if (imageDirectory.isDirectory()) break block5;
                CommonUIPlugin.INSTANCE.log("Failed to create image directory " + imageDirectory.toString());
                return null;
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return imageDirectory;
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            int i = 0;
            while (i < listFiles.length) {
                this.delete(listFiles[i]);
                ++i;
            }
        }
        file.delete();
    }

    private File getNewFile() {
        File file;
        while ((file = new File(this.imageDirectory, String.valueOf(String.valueOf(this.imageCount++)) + ".png")).exists()) {
        }
        return file;
    }

    void dispose() {
        if (this.imageDirectory != null) {
            this.delete(this.imageDirectory);
        }
        this.descriptorToURIMap = null;
    }
}

