/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.sideeffect;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.runtime.Assert;

public final class SideEffect
implements ISideEffect {
    public static final ISideEffect NULL_SIDE_EFFECT = new ISideEffect(){

        @Override
        public void dispose() {
        }

        @Override
        public void pause() {
        }

        @Override
        public void resume() {
        }

        @Override
        public void resumeAndRunIfDirty() {
        }

        @Override
        public void runIfDirty() {
        }

        @Override
        public boolean isDisposed() {
            return true;
        }

        @Override
        public void addDisposeListener(Consumer<ISideEffect> disposalConsumer) {
        }

        @Override
        public void removeDisposeListener(Consumer<ISideEffect> disposalConsumer) {
        }
    };
    private boolean dirty;
    private boolean asyncScheduled;
    private int pauseDepth;
    private Runnable runnable;
    private IObservable[] dependencies;
    private final Realm realm;
    private final PrivateInterface privateInterface = new PrivateInterface();
    private List<Consumer<ISideEffect>> disposeListeners;

    public SideEffect(Runnable runnable) {
        this(Realm.getDefault(), runnable);
    }

    public SideEffect(Realm realm, Runnable runnable) {
        this.runnable = runnable;
        this.realm = realm;
        this.dirty = true;
        this.pauseDepth = 1;
    }

    public SideEffect(Runnable runnable, IObservable ... dependencies) {
        this.dependencies = dependencies;
        this.runnable = runnable;
        this.dirty = false;
        this.pauseDepth = 0;
        this.realm = Realm.getDefault();
        IObservable[] iObservableArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable next = iObservableArray[n2];
            next.addChangeListener(this.privateInterface);
            ++n2;
        }
    }

    @Override
    public void resume() {
        this.checkRealm();
        --this.pauseDepth;
        if (this.pauseDepth < 0) {
            throw new IllegalStateException("The resume() method was called more times than pause().");
        }
        if (this.dirty && this.pauseDepth == 0) {
            this.scheduleUpdate();
        }
    }

    @Override
    public void pause() {
        this.checkRealm();
        ++this.pauseDepth;
        if (this.dirty && this.pauseDepth == 1) {
            this.stopListening();
            this.dependencies = null;
        }
    }

    @Override
    public void resumeAndRunIfDirty() {
        this.checkRealm();
        --this.pauseDepth;
        this.update();
    }

    private void update() {
        if (this.dirty && this.pauseDepth <= 0) {
            this.dirty = false;
            this.stopListening();
            IObservable[] newDependencies = ObservableTracker.runAndMonitor(this.runnable, null, null);
            if (this.isDisposed()) {
                return;
            }
            IObservable[] iObservableArray = newDependencies;
            int n = newDependencies.length;
            int n2 = 0;
            while (n2 < n) {
                IObservable next = iObservableArray[n2];
                next.addChangeListener(this.privateInterface);
                ++n2;
            }
            this.dependencies = newDependencies;
        }
    }

    @Override
    public void dispose() {
        this.checkRealm();
        if (this.isDisposed()) {
            return;
        }
        this.pauseDepth = 0;
        this.stopListening();
        this.dependencies = null;
        this.runnable = null;
        if (this.disposeListeners != null) {
            List<Consumer<ISideEffect>> oldListeners = this.disposeListeners;
            this.disposeListeners = null;
            oldListeners.forEach(dc -> dc.accept(this));
        }
    }

    @Override
    public boolean isDisposed() {
        return this.runnable == null;
    }

    @Override
    public void addDisposeListener(Consumer<ISideEffect> disposalConsumer) {
        this.checkRealm();
        if (this.isDisposed()) {
            return;
        }
        if (this.disposeListeners == null) {
            this.disposeListeners = new ArrayList<Consumer<ISideEffect>>();
        }
        this.disposeListeners.add(disposalConsumer);
    }

    @Override
    public void removeDisposeListener(Consumer<ISideEffect> disposalConsumer) {
        this.checkRealm();
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.remove(disposalConsumer);
    }

    @Override
    public void runIfDirty() {
        this.checkRealm();
        this.update();
    }

    private void stopListening() {
        if (this.dependencies != null) {
            IObservable[] iObservableArray = this.dependencies;
            int n = this.dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                IObservable observable = iObservableArray[n2];
                observable.removeChangeListener(this.privateInterface);
                ++n2;
            }
        }
    }

    private void markDirtyInternal() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.pauseDepth <= 0) {
                this.scheduleUpdate();
            } else {
                this.stopListening();
                this.dependencies = null;
            }
        }
    }

    private void scheduleUpdate() {
        if (this.asyncScheduled) {
            return;
        }
        this.asyncScheduled = true;
        this.realm.asyncExec(this.privateInterface);
    }

    private void checkRealm() {
        Assert.isTrue((boolean)this.realm.isCurrent(), (String)"This operation must be run within the observable's realm");
    }

    public static <T> Runnable makeRunnable(Supplier<T> supplier, Consumer<T> consumer) {
        return () -> {
            Object value = supplier.get();
            ObservableTracker.setIgnore(true);
            try {
                consumer.accept(value);
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
        };
    }

    private class PrivateInterface
    implements IChangeListener,
    Runnable {
        private PrivateInterface() {
        }

        @Override
        public void handleChange(ChangeEvent event) {
            SideEffect.this.markDirtyInternal();
        }

        @Override
        public void run() {
            if (SideEffect.this.isDisposed()) {
                return;
            }
            SideEffect.this.asyncScheduled = false;
            SideEffect.this.update();
        }
    }
}

