/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class LaunchInfoCache {
    private static Map<ILaunchConfiguration, CachedInfo> infoCache = new HashMap<ILaunchConfiguration, CachedInfo>();

    public static synchronized CachedInfo getInfo(ILaunchConfiguration configuration) {
        CachedInfo info = infoCache.get(configuration);
        if (info == null) {
            info = new CachedInfo();
            infoCache.put(configuration, info);
        }
        return info;
    }

    public static synchronized void copyCache(ILaunchConfiguration launchConfiguration, ILaunchConfigurationWorkingCopy copy) {
        CachedInfo info = infoCache.get(launchConfiguration);
        if (info != null) {
            infoCache.put((ILaunchConfiguration)copy, info);
        }
    }

    public static synchronized void remove(ILaunchConfiguration launchConfiguration) {
        infoCache.remove(launchConfiguration);
    }

    public static class CachedInfo {
        public Map<String, Object> fAllBundles;
        public Map<Object, String> fModels;
        public Object target;
        public String[] programArgs;
        public String[] vmArgs;
        public Map<String, Object> data = new HashMap<String, Object>();
    }
}

