/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.pde.api.tools.internal.provisional.IVersionRange;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class BundleVersionRange
implements IVersionRange {
    private final VersionRange fRange;

    public BundleVersionRange(String versionInterval) {
        this.fRange = new VersionRange(versionInterval);
    }

    public BundleVersionRange(VersionRange range) {
        this.fRange = range;
    }

    @Override
    public String getMaximumVersion() {
        Version right = this.fRange.getRight();
        return right != null ? right.toString() : null;
    }

    @Override
    public String getMinimumVersion() {
        return this.fRange.getLeft().toString();
    }

    @Override
    public boolean isIncludeMaximum() {
        return this.fRange.getRightType() == ']';
    }

    @Override
    public boolean isIncludeMinimum() {
        return this.fRange.getLeftType() == '[';
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundleVersionRange) {
            BundleVersionRange range = (BundleVersionRange)obj;
            return this.fRange.equals((Object)range.fRange);
        }
        return false;
    }

    public int hashCode() {
        return this.fRange.hashCode();
    }

    public String toString() {
        return this.fRange.toString();
    }

    @Override
    public boolean isIncluded(String version) {
        return this.fRange.includes(new Version(version));
    }
}

