/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.mapdb.MapDbCollectionFactory;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.LockManager;
import org.eclipse.rdf4j.common.io.MavenUtil;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.base.SnapshotSailStore;
import org.eclipse.rdf4j.sail.helpers.AbstractNotifyingSail;
import org.eclipse.rdf4j.sail.helpers.DirectoryLockManager;
import org.eclipse.rdf4j.sail.lmdb.LmdbSailStore;
import org.eclipse.rdf4j.sail.lmdb.LmdbStoreConnection;
import org.eclipse.rdf4j.sail.lmdb.MemoryOverflowModel;
import org.eclipse.rdf4j.sail.lmdb.config.LmdbStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class LmdbStore
extends AbstractNotifyingSail
implements FederatedServiceResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(LmdbStore.class);
    private static final String VERSION = MavenUtil.loadVersion((String)"org.eclipse.rdf4j", (String)"rdf4j-sail-lmdb", (String)"devel");
    private final LmdbStoreConfig config;
    private SailStore store;
    private LmdbSailStore backingStore;
    private boolean isWritable;
    private boolean isTmpDatadir = false;
    private volatile Lock dirLock;
    private EvaluationStrategyFactory evalStratFactory;
    private FederatedServiceResolver serviceResolver;
    private SPARQLServiceResolver dependentServiceResolver;
    private final ReentrantLock txnLockManager = new ReentrantLock();
    private final LockManager isolatedLockManager = new LockManager(LmdbStore.debugEnabled());
    private final LockManager disabledIsolationLockManager = new LockManager(LmdbStore.debugEnabled());

    public LmdbStore() {
        this(new LmdbStoreConfig());
    }

    public LmdbStore(LmdbStoreConfig config) {
        this.config = config;
        this.setSupportedIsolationLevels(new IsolationLevel[]{IsolationLevels.NONE, IsolationLevels.READ_COMMITTED, IsolationLevels.SNAPSHOT_READ, IsolationLevels.SNAPSHOT, IsolationLevels.SERIALIZABLE});
        this.setDefaultIsolationLevel((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
        config.getDefaultQueryEvaluationMode().ifPresent(arg_0 -> ((LmdbStore)this).setDefaultQueryEvaluationMode(arg_0));
        EvaluationStrategyFactory evalStrategyFactory = config.getEvaluationStrategyFactory();
        if (evalStrategyFactory != null) {
            this.setEvaluationStrategyFactory(evalStrategyFactory);
        }
    }

    public LmdbStore(File dataDir) {
        this(dataDir, new LmdbStoreConfig());
    }

    public LmdbStore(File dataDir, LmdbStoreConfig config) {
        this(config);
        this.setDataDir(dataDir);
    }

    public void setDataDir(File dataDir) {
        super.setDataDir(dataDir);
        this.isTmpDatadir = dataDir == null;
    }

    public synchronized EvaluationStrategyFactory getEvaluationStrategyFactory() {
        if (this.evalStratFactory == null) {
            this.evalStratFactory = new StrictEvaluationStrategyFactory(this.getFederatedServiceResolver());
        }
        this.evalStratFactory.setQuerySolutionCacheThreshold(this.getIterationCacheSyncThreshold());
        this.evalStratFactory.setTrackResultSize(this.isTrackResultSize());
        this.evalStratFactory.setCollectionFactory(this.getCollectionFactory());
        return this.evalStratFactory;
    }

    public synchronized void setEvaluationStrategyFactory(EvaluationStrategyFactory factory) {
        this.evalStratFactory = factory;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new SPARQLServiceResolver();
            }
            this.setFederatedServiceResolver((FederatedServiceResolver)this.dependentServiceResolver);
        }
        return this.serviceResolver;
    }

    public synchronized void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        if (resolver != null && this.evalStratFactory instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)this.evalStratFactory).setFederatedServiceResolver(resolver);
        }
    }

    protected void initializeInternal() throws SailException {
        logger.debug("Initializing LmdbStore...");
        File dataDir = this.getDataDir();
        if (dataDir == null) {
            try {
                this.setDataDir(Files.createTempDirectory("rdf4j-lmdb-tmp", new FileAttribute[0]).toFile());
                this.isTmpDatadir = true;
            }
            catch (IOException ioe) {
                throw new SailException("Temp data dir could not be created");
            }
            dataDir = this.getDataDir();
        } else if (!dataDir.exists()) {
            boolean success = dataDir.mkdirs();
            if (!success) {
                throw new SailException("Unable to create data directory: " + dataDir);
            }
        } else {
            if (!dataDir.isDirectory()) {
                throw new SailException("The specified path does not denote a directory: " + dataDir);
            }
            if (!dataDir.canRead()) {
                throw new SailException("Not allowed to read from the specified directory: " + dataDir);
            }
        }
        this.dirLock = new DirectoryLockManager(dataDir).lockOrFail();
        logger.debug("Data dir is " + dataDir);
        try {
            String version;
            File versionFile = new File(dataDir, "lmdbrdf.ver");
            String string = version = versionFile.exists() ? FileUtils.readFileToString((File)versionFile, (Charset)StandardCharsets.UTF_8) : null;
            if (!VERSION.equals(version) && this.upgradeStore(dataDir, version)) {
                FileUtils.writeStringToFile((File)versionFile, (String)VERSION, (Charset)StandardCharsets.UTF_8);
            }
            this.backingStore = new LmdbSailStore(dataDir, this.config);
            this.store = new SnapshotSailStore(this.backingStore, () -> new MemoryOverflowModel(){

                @Override
                protected SailStore createSailStore(File dataDir) throws IOException, SailException {
                    return new LmdbSailStore(dataDir, LmdbStore.this.config);
                }
            }){

                public SailSource getExplicitSailSource() {
                    if (LmdbStore.this.isIsolationDisabled()) {
                        return LmdbStore.this.backingStore.getExplicitSailSource();
                    }
                    return super.getExplicitSailSource();
                }

                public SailSource getInferredSailSource() {
                    if (LmdbStore.this.isIsolationDisabled()) {
                        return LmdbStore.this.backingStore.getInferredSailSource();
                    }
                    return super.getInferredSailSource();
                }
            };
        }
        catch (Throwable e) {
            this.dirLock.release();
            throw new SailException(e);
        }
        this.isWritable = this.getDataDir().canWrite();
        logger.debug("LmdbStore initialized");
    }

    protected void shutDownInternal() throws SailException {
        File dataDir;
        logger.debug("Shutting down LmdbStore...");
        try {
            this.store.close();
        }
        finally {
            this.dirLock.release();
            if (this.dependentServiceResolver != null) {
                this.dependentServiceResolver.shutDown();
            }
        }
        if (this.isTmpDatadir && (dataDir = this.getDataDir()) != null) {
            try {
                Files.walk(dataDir.toPath(), new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
            }
            catch (IOException ioe) {
                logger.error("Could not delete temp file " + dataDir);
            }
        }
        logger.debug("LmdbStore shut down");
    }

    public void shutDown() throws SailException {
        super.shutDown();
        if (this.isTmpDatadir) {
            this.setDataDir(null);
        }
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    protected NotifyingSailConnection getConnectionInternal() throws SailException {
        try {
            return new LmdbStoreConnection(this);
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
    }

    public ValueFactory getValueFactory() {
        return this.store.getValueFactory();
    }

    protected Lock getTransactionLock(IsolationLevel level) throws SailException {
        this.txnLockManager.lock();
        try {
            if (IsolationLevels.NONE.isCompatibleWith(level)) {
                this.isolatedLockManager.waitForActiveLocks();
                Lock lock = this.disabledIsolationLockManager.createLock(level.toString());
                return lock;
            }
            this.disabledIsolationLockManager.waitForActiveLocks();
            Lock lock = this.isolatedLockManager.createLock(level.toString());
            return lock;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SailException((Throwable)e);
        }
        finally {
            this.txnLockManager.unlock();
        }
    }

    boolean isIsolationDisabled() {
        return this.disabledIsolationLockManager.isActiveLock();
    }

    SailStore getSailStore() {
        return this.store;
    }

    LmdbSailStore getBackingStore() {
        return this.backingStore;
    }

    private boolean upgradeStore(File dataDir, String version) throws IOException, SailException {
        return true;
    }

    public Supplier<CollectionFactory> getCollectionFactory() {
        return () -> new MapDbCollectionFactory(this.getIterationCacheSyncThreshold());
    }
}

