/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FedXConfig;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.EndpointFactory;
import org.eclipse.rdf4j.federated.evaluation.FederationEvaluationStrategyFactory;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.federated.write.WriteStrategyFactory;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedXFactory {
    protected static final Logger log = LoggerFactory.getLogger(FedXFactory.class);
    protected RepositoryResolver repositoryResolver;
    protected FederatedServiceResolver federatedServiceResolver;
    protected FederationEvaluationStrategyFactory strategyFactory;
    protected WriteStrategyFactory writeStrategyFactory;
    protected List<Endpoint> members = new ArrayList<Endpoint>();
    protected FedXConfig config = FedXConfig.DEFAULT_CONFIG;
    protected File fedxBaseDir;

    public static FedXRepository createSparqlFederation(List<String> sparqlEndpoints) throws Exception {
        return FedXFactory.newFederation().withSparqlEndpoints(sparqlEndpoints).create();
    }

    public static FedXRepository createFederation(File dataConfig) throws Exception {
        return FedXFactory.newFederation().withMembers(dataConfig).create();
    }

    public static FedXRepository createFederation(List<Endpoint> endpoints) throws FedXException {
        return FedXFactory.newFederation().withMembers(endpoints).create();
    }

    public static FedXFactory newFederation() {
        return new FedXFactory();
    }

    private FedXFactory() {
    }

    public FedXFactory withRepositoryResolver(RepositoryResolver repositoryResolver) {
        this.repositoryResolver = repositoryResolver;
        return this;
    }

    public FedXFactory withFederatedServiceResolver(FederatedServiceResolver federatedServiceResolver) {
        this.federatedServiceResolver = federatedServiceResolver;
        return this;
    }

    public FedXFactory withFederationEvaluationStrategyFactory(FederationEvaluationStrategyFactory strategyFactory) {
        this.strategyFactory = strategyFactory;
        return this;
    }

    public FedXFactory withWriteStrategyFactory(WriteStrategyFactory writeStrategyFactory) {
        this.writeStrategyFactory = writeStrategyFactory;
        return this;
    }

    public FedXFactory withMembers(List<Endpoint> endpoints) {
        this.members.addAll(endpoints);
        return this;
    }

    public FedXFactory withMembers(File dataConfig) {
        log.info("Loading federation members from dataConfig " + dataConfig + ".");
        this.members.addAll(EndpointFactory.loadFederationMembers(dataConfig, this.fedxBaseDir));
        return this;
    }

    public FedXFactory withMembers(Model model) {
        log.debug("Loading federation members from model.");
        this.members.addAll(EndpointFactory.loadFederationMembers(model, this.fedxBaseDir));
        return this;
    }

    public FedXFactory withSparqlEndpoint(String sparqlEndpoint) {
        this.members.add(EndpointFactory.loadSPARQLEndpoint(sparqlEndpoint));
        return this;
    }

    public FedXFactory withSparqlEndpoints(List<String> sparqlEndpoints) {
        for (String sparqlEndpoint : sparqlEndpoints) {
            this.withSparqlEndpoint(sparqlEndpoint);
        }
        return this;
    }

    public FedXFactory withResolvableEndpoint(String repositoryId) {
        return this.withResolvableEndpoint(repositoryId, false);
    }

    public FedXFactory withResolvableEndpoint(String repositoryId, boolean writable) {
        this.members.add(EndpointFactory.loadResolvableRepository(repositoryId, writable));
        return this;
    }

    public FedXFactory withConfig(FedXConfig config) {
        this.config = config;
        return this;
    }

    public FedXFactory withFedXBaseDir(File fedxBaseDir) {
        this.fedxBaseDir = fedxBaseDir;
        return this;
    }

    public FedXRepository create() {
        if (this.members.isEmpty()) {
            log.info("Initializing federation without any pre-configured members");
        }
        FedX federation = new FedX(this.members);
        if (this.strategyFactory != null) {
            federation.setFederationEvaluationStrategy(this.strategyFactory);
        }
        if (this.writeStrategyFactory != null) {
            federation.setWriteStrategyFactory(this.writeStrategyFactory);
        }
        FedXRepository repo = new FedXRepository(federation, this.config);
        if (this.repositoryResolver != null) {
            repo.setRepositoryResolver(this.repositoryResolver);
        }
        if (this.federatedServiceResolver != null) {
            repo.setFederatedServiceResolver(this.federatedServiceResolver);
        }
        if (this.fedxBaseDir != null) {
            repo.setDataDir(this.fedxBaseDir);
        }
        return repo;
    }
}

