/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.LimitIteration;
import org.eclipse.rdf4j.common.iteration.OffsetIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;

public interface SliceQueryEvaluationStep
extends QueryEvaluationStep {
    public static QueryEvaluationStep supply(Slice slice, QueryEvaluationStep argument) {
        if (!slice.hasOffset() && !slice.hasLimit()) {
            return argument;
        }
        if (slice.hasOffset() && slice.hasLimit()) {
            return new OffSetAndLimitQueryEvaluationStep(slice.getOffset(), slice.getLimit(), argument);
        }
        if (slice.hasOffset() && !slice.hasLimit()) {
            return new OnlyOffsetQueryEvaluationStep(slice.getOffset(), argument);
        }
        return new OnlyLimitQueryEvaluationStep(slice.getLimit(), argument);
    }

    public static class OnlyLimitQueryEvaluationStep
    implements SliceQueryEvaluationStep {
        private final long limit;
        private final QueryEvaluationStep argument;

        public OnlyLimitQueryEvaluationStep(long limit, QueryEvaluationStep argument) {
            this.limit = limit;
            this.argument = argument;
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
            return new LimitIteration(this.argument.evaluate(bs), this.limit);
        }
    }

    public static class OffSetAndLimitQueryEvaluationStep
    implements SliceQueryEvaluationStep {
        private final long offset;
        private final long limit;
        private final QueryEvaluationStep argument;

        public OffSetAndLimitQueryEvaluationStep(long offset, long limit, QueryEvaluationStep argument) {
            this.offset = offset;
            this.limit = limit;
            this.argument = argument;
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
            CloseableIteration<BindingSet, QueryEvaluationException> evaluate = this.argument.evaluate(bs);
            return new LimitIteration((Iteration)new OffsetIteration(evaluate, this.offset), this.limit);
        }
    }

    public static class OnlyOffsetQueryEvaluationStep
    implements SliceQueryEvaluationStep {
        private final long offset;
        private final QueryEvaluationStep argument;

        public OnlyOffsetQueryEvaluationStep(long offset, QueryEvaluationStep argument) {
            this.offset = offset;
            this.argument = argument;
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
            return new OffsetIteration(this.argument.evaluate(bs), this.offset);
        }
    }
}

